import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::index
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:30
* @route '/societies/{society}/team'
*/
export const index = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/team',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::index
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:30
* @route '/societies/{society}/team'
*/
index.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::index
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:30
* @route '/societies/{society}/team'
*/
index.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::index
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:30
* @route '/societies/{society}/team'
*/
index.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::index
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:30
* @route '/societies/{society}/team'
*/
const indexForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::index
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:30
* @route '/societies/{society}/team'
*/
indexForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::index
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:30
* @route '/societies/{society}/team'
*/
indexForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::store
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:74
* @route '/societies/{society}/team'
*/
export const store = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/societies/{society}/team',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::store
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:74
* @route '/societies/{society}/team'
*/
store.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return store.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::store
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:74
* @route '/societies/{society}/team'
*/
store.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::store
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:74
* @route '/societies/{society}/team'
*/
const storeForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::store
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:74
* @route '/societies/{society}/team'
*/
storeForm.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::update
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:120
* @route '/societies/{society}/team/{team}'
*/
export const update = (args: { society: number | { id: number }, team: number | { id: number } } | [society: number | { id: number }, team: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/societies/{society}/team/{team}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::update
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:120
* @route '/societies/{society}/team/{team}'
*/
update.url = (args: { society: number | { id: number }, team: number | { id: number } } | [society: number | { id: number }, team: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            team: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        team: typeof args.team === 'object'
        ? args.team.id
        : args.team,
    }

    return update.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{team}', parsedArgs.team.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::update
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:120
* @route '/societies/{society}/team/{team}'
*/
update.put = (args: { society: number | { id: number }, team: number | { id: number } } | [society: number | { id: number }, team: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::update
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:120
* @route '/societies/{society}/team/{team}'
*/
update.patch = (args: { society: number | { id: number }, team: number | { id: number } } | [society: number | { id: number }, team: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::update
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:120
* @route '/societies/{society}/team/{team}'
*/
const updateForm = (args: { society: number | { id: number }, team: number | { id: number } } | [society: number | { id: number }, team: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::update
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:120
* @route '/societies/{society}/team/{team}'
*/
updateForm.put = (args: { society: number | { id: number }, team: number | { id: number } } | [society: number | { id: number }, team: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::update
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:120
* @route '/societies/{society}/team/{team}'
*/
updateForm.patch = (args: { society: number | { id: number }, team: number | { id: number } } | [society: number | { id: number }, team: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PATCH',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::destroy
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:172
* @route '/societies/{society}/team/{team}'
*/
export const destroy = (args: { society: number | { id: number }, team: number | { id: number } } | [society: number | { id: number }, team: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/societies/{society}/team/{team}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::destroy
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:172
* @route '/societies/{society}/team/{team}'
*/
destroy.url = (args: { society: number | { id: number }, team: number | { id: number } } | [society: number | { id: number }, team: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            team: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        team: typeof args.team === 'object'
        ? args.team.id
        : args.team,
    }

    return destroy.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{team}', parsedArgs.team.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::destroy
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:172
* @route '/societies/{society}/team/{team}'
*/
destroy.delete = (args: { society: number | { id: number }, team: number | { id: number } } | [society: number | { id: number }, team: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::destroy
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:172
* @route '/societies/{society}/team/{team}'
*/
const destroyForm = (args: { society: number | { id: number }, team: number | { id: number } } | [society: number | { id: number }, team: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\TeamController::destroy
* @see app/Http/Controllers/SocietyAdmin/TeamController.php:172
* @route '/societies/{society}/team/{team}'
*/
destroyForm.delete = (args: { society: number | { id: number }, team: number | { id: number } } | [society: number | { id: number }, team: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const TeamController = { index, store, update, destroy }

export default TeamController