import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::index
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:20
* @route '/societies/{society}/reports'
*/
export const index = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/reports',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::index
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:20
* @route '/societies/{society}/reports'
*/
index.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::index
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:20
* @route '/societies/{society}/reports'
*/
index.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::index
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:20
* @route '/societies/{society}/reports'
*/
index.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::index
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:20
* @route '/societies/{society}/reports'
*/
const indexForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::index
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:20
* @route '/societies/{society}/reports'
*/
indexForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::index
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:20
* @route '/societies/{society}/reports'
*/
indexForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::collectionSummary
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:39
* @route '/societies/{society}/reports/collection-summary'
*/
export const collectionSummary = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: collectionSummary.url(args, options),
    method: 'get',
})

collectionSummary.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/reports/collection-summary',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::collectionSummary
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:39
* @route '/societies/{society}/reports/collection-summary'
*/
collectionSummary.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return collectionSummary.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::collectionSummary
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:39
* @route '/societies/{society}/reports/collection-summary'
*/
collectionSummary.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: collectionSummary.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::collectionSummary
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:39
* @route '/societies/{society}/reports/collection-summary'
*/
collectionSummary.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: collectionSummary.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::collectionSummary
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:39
* @route '/societies/{society}/reports/collection-summary'
*/
const collectionSummaryForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: collectionSummary.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::collectionSummary
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:39
* @route '/societies/{society}/reports/collection-summary'
*/
collectionSummaryForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: collectionSummary.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::collectionSummary
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:39
* @route '/societies/{society}/reports/collection-summary'
*/
collectionSummaryForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: collectionSummary.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

collectionSummary.form = collectionSummaryForm

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::arrears
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:117
* @route '/societies/{society}/reports/arrears'
*/
export const arrears = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: arrears.url(args, options),
    method: 'get',
})

arrears.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/reports/arrears',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::arrears
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:117
* @route '/societies/{society}/reports/arrears'
*/
arrears.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return arrears.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::arrears
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:117
* @route '/societies/{society}/reports/arrears'
*/
arrears.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: arrears.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::arrears
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:117
* @route '/societies/{society}/reports/arrears'
*/
arrears.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: arrears.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::arrears
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:117
* @route '/societies/{society}/reports/arrears'
*/
const arrearsForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: arrears.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::arrears
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:117
* @route '/societies/{society}/reports/arrears'
*/
arrearsForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: arrears.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::arrears
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:117
* @route '/societies/{society}/reports/arrears'
*/
arrearsForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: arrears.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

arrears.form = arrearsForm

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::expenseBreakdown
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:201
* @route '/societies/{society}/reports/expense-breakdown'
*/
export const expenseBreakdown = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: expenseBreakdown.url(args, options),
    method: 'get',
})

expenseBreakdown.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/reports/expense-breakdown',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::expenseBreakdown
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:201
* @route '/societies/{society}/reports/expense-breakdown'
*/
expenseBreakdown.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return expenseBreakdown.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::expenseBreakdown
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:201
* @route '/societies/{society}/reports/expense-breakdown'
*/
expenseBreakdown.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: expenseBreakdown.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::expenseBreakdown
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:201
* @route '/societies/{society}/reports/expense-breakdown'
*/
expenseBreakdown.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: expenseBreakdown.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::expenseBreakdown
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:201
* @route '/societies/{society}/reports/expense-breakdown'
*/
const expenseBreakdownForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: expenseBreakdown.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::expenseBreakdown
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:201
* @route '/societies/{society}/reports/expense-breakdown'
*/
expenseBreakdownForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: expenseBreakdown.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::expenseBreakdown
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:201
* @route '/societies/{society}/reports/expense-breakdown'
*/
expenseBreakdownForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: expenseBreakdown.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

expenseBreakdown.form = expenseBreakdownForm

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::financialSummary
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:287
* @route '/societies/{society}/reports/financial-summary'
*/
export const financialSummary = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: financialSummary.url(args, options),
    method: 'get',
})

financialSummary.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/reports/financial-summary',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::financialSummary
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:287
* @route '/societies/{society}/reports/financial-summary'
*/
financialSummary.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return financialSummary.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::financialSummary
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:287
* @route '/societies/{society}/reports/financial-summary'
*/
financialSummary.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: financialSummary.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::financialSummary
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:287
* @route '/societies/{society}/reports/financial-summary'
*/
financialSummary.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: financialSummary.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::financialSummary
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:287
* @route '/societies/{society}/reports/financial-summary'
*/
const financialSummaryForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: financialSummary.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::financialSummary
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:287
* @route '/societies/{society}/reports/financial-summary'
*/
financialSummaryForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: financialSummary.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ReportController::financialSummary
* @see app/Http/Controllers/SocietyAdmin/ReportController.php:287
* @route '/societies/{society}/reports/financial-summary'
*/
financialSummaryForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: financialSummary.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

financialSummary.form = financialSummaryForm

const ReportController = { index, collectionSummary, arrears, expenseBreakdown, financialSummary }

export default ReportController