import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::generateQRCode
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:414
* @route '/societies/{society}/payments/generate-qr'
*/
export const generateQRCode = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: generateQRCode.url(args, options),
    method: 'post',
})

generateQRCode.definition = {
    methods: ["post"],
    url: '/societies/{society}/payments/generate-qr',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::generateQRCode
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:414
* @route '/societies/{society}/payments/generate-qr'
*/
generateQRCode.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return generateQRCode.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::generateQRCode
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:414
* @route '/societies/{society}/payments/generate-qr'
*/
generateQRCode.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: generateQRCode.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::generateQRCode
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:414
* @route '/societies/{society}/payments/generate-qr'
*/
const generateQRCodeForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: generateQRCode.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::generateQRCode
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:414
* @route '/societies/{society}/payments/generate-qr'
*/
generateQRCodeForm.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: generateQRCode.url(args, options),
    method: 'post',
})

generateQRCode.form = generateQRCodeForm

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::sendPaymentRequest
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:494
* @route '/societies/{society}/payments/send-request'
*/
export const sendPaymentRequest = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: sendPaymentRequest.url(args, options),
    method: 'post',
})

sendPaymentRequest.definition = {
    methods: ["post"],
    url: '/societies/{society}/payments/send-request',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::sendPaymentRequest
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:494
* @route '/societies/{society}/payments/send-request'
*/
sendPaymentRequest.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return sendPaymentRequest.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::sendPaymentRequest
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:494
* @route '/societies/{society}/payments/send-request'
*/
sendPaymentRequest.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: sendPaymentRequest.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::sendPaymentRequest
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:494
* @route '/societies/{society}/payments/send-request'
*/
const sendPaymentRequestForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: sendPaymentRequest.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::sendPaymentRequest
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:494
* @route '/societies/{society}/payments/send-request'
*/
sendPaymentRequestForm.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: sendPaymentRequest.url(args, options),
    method: 'post',
})

sendPaymentRequest.form = sendPaymentRequestForm

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::checkPaymentStatus
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:632
* @route '/societies/{society}/payments/check-status/{linkId}'
*/
export const checkPaymentStatus = (args: { society: number | { id: number }, linkId: string | number } | [society: number | { id: number }, linkId: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: checkPaymentStatus.url(args, options),
    method: 'get',
})

checkPaymentStatus.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/payments/check-status/{linkId}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::checkPaymentStatus
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:632
* @route '/societies/{society}/payments/check-status/{linkId}'
*/
checkPaymentStatus.url = (args: { society: number | { id: number }, linkId: string | number } | [society: number | { id: number }, linkId: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            linkId: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        linkId: args.linkId,
    }

    return checkPaymentStatus.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{linkId}', parsedArgs.linkId.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::checkPaymentStatus
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:632
* @route '/societies/{society}/payments/check-status/{linkId}'
*/
checkPaymentStatus.get = (args: { society: number | { id: number }, linkId: string | number } | [society: number | { id: number }, linkId: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: checkPaymentStatus.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::checkPaymentStatus
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:632
* @route '/societies/{society}/payments/check-status/{linkId}'
*/
checkPaymentStatus.head = (args: { society: number | { id: number }, linkId: string | number } | [society: number | { id: number }, linkId: string | number ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: checkPaymentStatus.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::checkPaymentStatus
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:632
* @route '/societies/{society}/payments/check-status/{linkId}'
*/
const checkPaymentStatusForm = (args: { society: number | { id: number }, linkId: string | number } | [society: number | { id: number }, linkId: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: checkPaymentStatus.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::checkPaymentStatus
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:632
* @route '/societies/{society}/payments/check-status/{linkId}'
*/
checkPaymentStatusForm.get = (args: { society: number | { id: number }, linkId: string | number } | [society: number | { id: number }, linkId: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: checkPaymentStatus.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::checkPaymentStatus
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:632
* @route '/societies/{society}/payments/check-status/{linkId}'
*/
checkPaymentStatusForm.head = (args: { society: number | { id: number }, linkId: string | number } | [society: number | { id: number }, linkId: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: checkPaymentStatus.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

checkPaymentStatus.form = checkPaymentStatusForm

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::getDueBills
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:392
* @route '/societies/{society}/payments/due-bills/{resident}'
*/
export const getDueBills = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getDueBills.url(args, options),
    method: 'get',
})

getDueBills.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/payments/due-bills/{resident}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::getDueBills
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:392
* @route '/societies/{society}/payments/due-bills/{resident}'
*/
getDueBills.url = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            resident: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        resident: typeof args.resident === 'object'
        ? args.resident.id
        : args.resident,
    }

    return getDueBills.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{resident}', parsedArgs.resident.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::getDueBills
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:392
* @route '/societies/{society}/payments/due-bills/{resident}'
*/
getDueBills.get = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getDueBills.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::getDueBills
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:392
* @route '/societies/{society}/payments/due-bills/{resident}'
*/
getDueBills.head = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: getDueBills.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::getDueBills
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:392
* @route '/societies/{society}/payments/due-bills/{resident}'
*/
const getDueBillsForm = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getDueBills.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::getDueBills
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:392
* @route '/societies/{society}/payments/due-bills/{resident}'
*/
getDueBillsForm.get = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getDueBills.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::getDueBills
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:392
* @route '/societies/{society}/payments/due-bills/{resident}'
*/
getDueBillsForm.head = (args: { society: number | { id: number }, resident: number | { id: number } } | [society: number | { id: number }, resident: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getDueBills.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

getDueBills.form = getDueBillsForm

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::reconcile
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:366
* @route '/societies/{society}/payments/{payment}/reconcile'
*/
export const reconcile = (args: { society: number | { id: number }, payment: number | { id: number } } | [society: number | { id: number }, payment: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: reconcile.url(args, options),
    method: 'post',
})

reconcile.definition = {
    methods: ["post"],
    url: '/societies/{society}/payments/{payment}/reconcile',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::reconcile
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:366
* @route '/societies/{society}/payments/{payment}/reconcile'
*/
reconcile.url = (args: { society: number | { id: number }, payment: number | { id: number } } | [society: number | { id: number }, payment: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            payment: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        payment: typeof args.payment === 'object'
        ? args.payment.id
        : args.payment,
    }

    return reconcile.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{payment}', parsedArgs.payment.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::reconcile
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:366
* @route '/societies/{society}/payments/{payment}/reconcile'
*/
reconcile.post = (args: { society: number | { id: number }, payment: number | { id: number } } | [society: number | { id: number }, payment: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: reconcile.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::reconcile
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:366
* @route '/societies/{society}/payments/{payment}/reconcile'
*/
const reconcileForm = (args: { society: number | { id: number }, payment: number | { id: number } } | [society: number | { id: number }, payment: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: reconcile.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::reconcile
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:366
* @route '/societies/{society}/payments/{payment}/reconcile'
*/
reconcileForm.post = (args: { society: number | { id: number }, payment: number | { id: number } } | [society: number | { id: number }, payment: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: reconcile.url(args, options),
    method: 'post',
})

reconcile.form = reconcileForm

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::index
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:25
* @route '/societies/{society}/payments'
*/
export const index = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/payments',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::index
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:25
* @route '/societies/{society}/payments'
*/
index.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::index
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:25
* @route '/societies/{society}/payments'
*/
index.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::index
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:25
* @route '/societies/{society}/payments'
*/
index.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::index
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:25
* @route '/societies/{society}/payments'
*/
const indexForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::index
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:25
* @route '/societies/{society}/payments'
*/
indexForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::index
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:25
* @route '/societies/{society}/payments'
*/
indexForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::create
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:109
* @route '/societies/{society}/payments/create'
*/
export const create = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/payments/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::create
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:109
* @route '/societies/{society}/payments/create'
*/
create.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return create.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::create
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:109
* @route '/societies/{society}/payments/create'
*/
create.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::create
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:109
* @route '/societies/{society}/payments/create'
*/
create.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::create
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:109
* @route '/societies/{society}/payments/create'
*/
const createForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::create
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:109
* @route '/societies/{society}/payments/create'
*/
createForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::create
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:109
* @route '/societies/{society}/payments/create'
*/
createForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::store
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:151
* @route '/societies/{society}/payments'
*/
export const store = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/societies/{society}/payments',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::store
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:151
* @route '/societies/{society}/payments'
*/
store.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return store.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::store
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:151
* @route '/societies/{society}/payments'
*/
store.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::store
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:151
* @route '/societies/{society}/payments'
*/
const storeForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::store
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:151
* @route '/societies/{society}/payments'
*/
storeForm.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::show
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:286
* @route '/societies/{society}/payments/{payment}'
*/
export const show = (args: { society: number | { id: number }, payment: number | { id: number } } | [society: number | { id: number }, payment: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/payments/{payment}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::show
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:286
* @route '/societies/{society}/payments/{payment}'
*/
show.url = (args: { society: number | { id: number }, payment: number | { id: number } } | [society: number | { id: number }, payment: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            payment: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        payment: typeof args.payment === 'object'
        ? args.payment.id
        : args.payment,
    }

    return show.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{payment}', parsedArgs.payment.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::show
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:286
* @route '/societies/{society}/payments/{payment}'
*/
show.get = (args: { society: number | { id: number }, payment: number | { id: number } } | [society: number | { id: number }, payment: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::show
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:286
* @route '/societies/{society}/payments/{payment}'
*/
show.head = (args: { society: number | { id: number }, payment: number | { id: number } } | [society: number | { id: number }, payment: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::show
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:286
* @route '/societies/{society}/payments/{payment}'
*/
const showForm = (args: { society: number | { id: number }, payment: number | { id: number } } | [society: number | { id: number }, payment: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::show
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:286
* @route '/societies/{society}/payments/{payment}'
*/
showForm.get = (args: { society: number | { id: number }, payment: number | { id: number } } | [society: number | { id: number }, payment: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::show
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:286
* @route '/societies/{society}/payments/{payment}'
*/
showForm.head = (args: { society: number | { id: number }, payment: number | { id: number } } | [society: number | { id: number }, payment: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::update
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:312
* @route '/societies/{society}/payments/{payment}'
*/
export const update = (args: { society: number | { id: number }, payment: number | { id: number } } | [society: number | { id: number }, payment: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/societies/{society}/payments/{payment}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::update
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:312
* @route '/societies/{society}/payments/{payment}'
*/
update.url = (args: { society: number | { id: number }, payment: number | { id: number } } | [society: number | { id: number }, payment: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            payment: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        payment: typeof args.payment === 'object'
        ? args.payment.id
        : args.payment,
    }

    return update.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{payment}', parsedArgs.payment.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::update
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:312
* @route '/societies/{society}/payments/{payment}'
*/
update.put = (args: { society: number | { id: number }, payment: number | { id: number } } | [society: number | { id: number }, payment: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::update
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:312
* @route '/societies/{society}/payments/{payment}'
*/
update.patch = (args: { society: number | { id: number }, payment: number | { id: number } } | [society: number | { id: number }, payment: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::update
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:312
* @route '/societies/{society}/payments/{payment}'
*/
const updateForm = (args: { society: number | { id: number }, payment: number | { id: number } } | [society: number | { id: number }, payment: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::update
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:312
* @route '/societies/{society}/payments/{payment}'
*/
updateForm.put = (args: { society: number | { id: number }, payment: number | { id: number } } | [society: number | { id: number }, payment: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\PaymentController::update
* @see app/Http/Controllers/SocietyAdmin/PaymentController.php:312
* @route '/societies/{society}/payments/{payment}'
*/
updateForm.patch = (args: { society: number | { id: number }, payment: number | { id: number } } | [society: number | { id: number }, payment: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PATCH',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

const PaymentController = { generateQRCode, sendPaymentRequest, checkPaymentStatus, getDueBills, reconcile, index, create, store, show, update }

export default PaymentController