import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::index
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:13
* @route '/societies/{society}/maintenance-structures'
*/
export const index = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/maintenance-structures',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::index
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:13
* @route '/societies/{society}/maintenance-structures'
*/
index.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::index
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:13
* @route '/societies/{society}/maintenance-structures'
*/
index.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::index
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:13
* @route '/societies/{society}/maintenance-structures'
*/
index.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::index
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:13
* @route '/societies/{society}/maintenance-structures'
*/
const indexForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::index
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:13
* @route '/societies/{society}/maintenance-structures'
*/
indexForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::index
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:13
* @route '/societies/{society}/maintenance-structures'
*/
indexForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::create
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:37
* @route '/societies/{society}/maintenance-structures/create'
*/
export const create = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/maintenance-structures/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::create
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:37
* @route '/societies/{society}/maintenance-structures/create'
*/
create.url = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: args.society,
    }

    return create.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::create
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:37
* @route '/societies/{society}/maintenance-structures/create'
*/
create.get = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::create
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:37
* @route '/societies/{society}/maintenance-structures/create'
*/
create.head = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::create
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:37
* @route '/societies/{society}/maintenance-structures/create'
*/
const createForm = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::create
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:37
* @route '/societies/{society}/maintenance-structures/create'
*/
createForm.get = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::create
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:37
* @route '/societies/{society}/maintenance-structures/create'
*/
createForm.head = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::store
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:45
* @route '/societies/{society}/maintenance-structures'
*/
export const store = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/societies/{society}/maintenance-structures',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::store
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:45
* @route '/societies/{society}/maintenance-structures'
*/
store.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return store.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::store
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:45
* @route '/societies/{society}/maintenance-structures'
*/
store.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::store
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:45
* @route '/societies/{society}/maintenance-structures'
*/
const storeForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::store
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:45
* @route '/societies/{society}/maintenance-structures'
*/
storeForm.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::show
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:69
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}'
*/
export const show = (args: { society: string | number, maintenance_structure: string | number } | [society: string | number, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/maintenance-structures/{maintenance_structure}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::show
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:69
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}'
*/
show.url = (args: { society: string | number, maintenance_structure: string | number } | [society: string | number, maintenance_structure: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            maintenance_structure: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: args.society,
        maintenance_structure: args.maintenance_structure,
    }

    return show.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{maintenance_structure}', parsedArgs.maintenance_structure.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::show
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:69
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}'
*/
show.get = (args: { society: string | number, maintenance_structure: string | number } | [society: string | number, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::show
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:69
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}'
*/
show.head = (args: { society: string | number, maintenance_structure: string | number } | [society: string | number, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::show
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:69
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}'
*/
const showForm = (args: { society: string | number, maintenance_structure: string | number } | [society: string | number, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::show
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:69
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}'
*/
showForm.get = (args: { society: string | number, maintenance_structure: string | number } | [society: string | number, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::show
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:69
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}'
*/
showForm.head = (args: { society: string | number, maintenance_structure: string | number } | [society: string | number, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::edit
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:77
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}/edit'
*/
export const edit = (args: { society: string | number, maintenance_structure: string | number } | [society: string | number, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/maintenance-structures/{maintenance_structure}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::edit
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:77
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}/edit'
*/
edit.url = (args: { society: string | number, maintenance_structure: string | number } | [society: string | number, maintenance_structure: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            maintenance_structure: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: args.society,
        maintenance_structure: args.maintenance_structure,
    }

    return edit.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{maintenance_structure}', parsedArgs.maintenance_structure.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::edit
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:77
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}/edit'
*/
edit.get = (args: { society: string | number, maintenance_structure: string | number } | [society: string | number, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::edit
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:77
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}/edit'
*/
edit.head = (args: { society: string | number, maintenance_structure: string | number } | [society: string | number, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::edit
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:77
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}/edit'
*/
const editForm = (args: { society: string | number, maintenance_structure: string | number } | [society: string | number, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::edit
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:77
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}/edit'
*/
editForm.get = (args: { society: string | number, maintenance_structure: string | number } | [society: string | number, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::edit
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:77
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}/edit'
*/
editForm.head = (args: { society: string | number, maintenance_structure: string | number } | [society: string | number, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::update
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:85
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}'
*/
export const update = (args: { society: number | { id: number }, maintenance_structure: string | number } | [society: number | { id: number }, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/societies/{society}/maintenance-structures/{maintenance_structure}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::update
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:85
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}'
*/
update.url = (args: { society: number | { id: number }, maintenance_structure: string | number } | [society: number | { id: number }, maintenance_structure: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            maintenance_structure: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        maintenance_structure: args.maintenance_structure,
    }

    return update.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{maintenance_structure}', parsedArgs.maintenance_structure.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::update
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:85
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}'
*/
update.put = (args: { society: number | { id: number }, maintenance_structure: string | number } | [society: number | { id: number }, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::update
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:85
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}'
*/
update.patch = (args: { society: number | { id: number }, maintenance_structure: string | number } | [society: number | { id: number }, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::update
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:85
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}'
*/
const updateForm = (args: { society: number | { id: number }, maintenance_structure: string | number } | [society: number | { id: number }, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::update
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:85
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}'
*/
updateForm.put = (args: { society: number | { id: number }, maintenance_structure: string | number } | [society: number | { id: number }, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::update
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:85
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}'
*/
updateForm.patch = (args: { society: number | { id: number }, maintenance_structure: string | number } | [society: number | { id: number }, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PATCH',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::destroy
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:109
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}'
*/
export const destroy = (args: { society: number | { id: number }, maintenance_structure: string | number } | [society: number | { id: number }, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/societies/{society}/maintenance-structures/{maintenance_structure}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::destroy
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:109
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}'
*/
destroy.url = (args: { society: number | { id: number }, maintenance_structure: string | number } | [society: number | { id: number }, maintenance_structure: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            maintenance_structure: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        maintenance_structure: args.maintenance_structure,
    }

    return destroy.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{maintenance_structure}', parsedArgs.maintenance_structure.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::destroy
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:109
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}'
*/
destroy.delete = (args: { society: number | { id: number }, maintenance_structure: string | number } | [society: number | { id: number }, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::destroy
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:109
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}'
*/
const destroyForm = (args: { society: number | { id: number }, maintenance_structure: string | number } | [society: number | { id: number }, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\MaintenanceStructureController::destroy
* @see app/Http/Controllers/SocietyAdmin/MaintenanceStructureController.php:109
* @route '/societies/{society}/maintenance-structures/{maintenance_structure}'
*/
destroyForm.delete = (args: { society: number | { id: number }, maintenance_structure: string | number } | [society: number | { id: number }, maintenance_structure: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const MaintenanceStructureController = { index, create, store, show, edit, update, destroy }

export default MaintenanceStructureController