import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::index
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:23
* @route '/societies/{society}/expenses'
*/
export const index = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/expenses',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::index
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:23
* @route '/societies/{society}/expenses'
*/
index.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::index
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:23
* @route '/societies/{society}/expenses'
*/
index.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::index
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:23
* @route '/societies/{society}/expenses'
*/
index.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::index
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:23
* @route '/societies/{society}/expenses'
*/
const indexForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::index
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:23
* @route '/societies/{society}/expenses'
*/
indexForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::index
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:23
* @route '/societies/{society}/expenses'
*/
indexForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::create
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:115
* @route '/societies/{society}/expenses/create'
*/
export const create = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/expenses/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::create
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:115
* @route '/societies/{society}/expenses/create'
*/
create.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return create.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::create
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:115
* @route '/societies/{society}/expenses/create'
*/
create.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::create
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:115
* @route '/societies/{society}/expenses/create'
*/
create.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::create
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:115
* @route '/societies/{society}/expenses/create'
*/
const createForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::create
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:115
* @route '/societies/{society}/expenses/create'
*/
createForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::create
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:115
* @route '/societies/{society}/expenses/create'
*/
createForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::store
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:151
* @route '/societies/{society}/expenses'
*/
export const store = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/societies/{society}/expenses',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::store
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:151
* @route '/societies/{society}/expenses'
*/
store.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return store.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::store
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:151
* @route '/societies/{society}/expenses'
*/
store.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::store
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:151
* @route '/societies/{society}/expenses'
*/
const storeForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::store
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:151
* @route '/societies/{society}/expenses'
*/
storeForm.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::show
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:197
* @route '/societies/{society}/expenses/{expense}'
*/
export const show = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/expenses/{expense}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::show
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:197
* @route '/societies/{society}/expenses/{expense}'
*/
show.url = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            expense: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        expense: typeof args.expense === 'object'
        ? args.expense.id
        : args.expense,
    }

    return show.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{expense}', parsedArgs.expense.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::show
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:197
* @route '/societies/{society}/expenses/{expense}'
*/
show.get = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::show
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:197
* @route '/societies/{society}/expenses/{expense}'
*/
show.head = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::show
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:197
* @route '/societies/{society}/expenses/{expense}'
*/
const showForm = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::show
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:197
* @route '/societies/{society}/expenses/{expense}'
*/
showForm.get = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::show
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:197
* @route '/societies/{society}/expenses/{expense}'
*/
showForm.head = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::edit
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:221
* @route '/societies/{society}/expenses/{expense}/edit'
*/
export const edit = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/expenses/{expense}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::edit
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:221
* @route '/societies/{society}/expenses/{expense}/edit'
*/
edit.url = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            expense: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        expense: typeof args.expense === 'object'
        ? args.expense.id
        : args.expense,
    }

    return edit.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{expense}', parsedArgs.expense.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::edit
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:221
* @route '/societies/{society}/expenses/{expense}/edit'
*/
edit.get = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::edit
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:221
* @route '/societies/{society}/expenses/{expense}/edit'
*/
edit.head = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::edit
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:221
* @route '/societies/{society}/expenses/{expense}/edit'
*/
const editForm = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::edit
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:221
* @route '/societies/{society}/expenses/{expense}/edit'
*/
editForm.get = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::edit
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:221
* @route '/societies/{society}/expenses/{expense}/edit'
*/
editForm.head = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::update
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:265
* @route '/societies/{society}/expenses/{expense}'
*/
export const update = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/societies/{society}/expenses/{expense}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::update
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:265
* @route '/societies/{society}/expenses/{expense}'
*/
update.url = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            expense: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        expense: typeof args.expense === 'object'
        ? args.expense.id
        : args.expense,
    }

    return update.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{expense}', parsedArgs.expense.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::update
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:265
* @route '/societies/{society}/expenses/{expense}'
*/
update.put = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::update
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:265
* @route '/societies/{society}/expenses/{expense}'
*/
update.patch = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::update
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:265
* @route '/societies/{society}/expenses/{expense}'
*/
const updateForm = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::update
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:265
* @route '/societies/{society}/expenses/{expense}'
*/
updateForm.put = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::update
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:265
* @route '/societies/{society}/expenses/{expense}'
*/
updateForm.patch = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PATCH',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::destroy
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:287
* @route '/societies/{society}/expenses/{expense}'
*/
export const destroy = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/societies/{society}/expenses/{expense}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::destroy
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:287
* @route '/societies/{society}/expenses/{expense}'
*/
destroy.url = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            expense: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        expense: typeof args.expense === 'object'
        ? args.expense.id
        : args.expense,
    }

    return destroy.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{expense}', parsedArgs.expense.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::destroy
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:287
* @route '/societies/{society}/expenses/{expense}'
*/
destroy.delete = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::destroy
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:287
* @route '/societies/{society}/expenses/{expense}'
*/
const destroyForm = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\ExpenseController::destroy
* @see app/Http/Controllers/SocietyAdmin/ExpenseController.php:287
* @route '/societies/{society}/expenses/{expense}'
*/
destroyForm.delete = (args: { society: number | { id: number }, expense: number | { id: number } } | [society: number | { id: number }, expense: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const ExpenseController = { index, create, store, show, edit, update, destroy }

export default ExpenseController