import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\CommunityPostController::index
* @see app/Http/Controllers/SocietyAdmin/CommunityPostController.php:13
* @route '/societies/{society}/community'
*/
export const index = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/community',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\CommunityPostController::index
* @see app/Http/Controllers/SocietyAdmin/CommunityPostController.php:13
* @route '/societies/{society}/community'
*/
index.url = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\CommunityPostController::index
* @see app/Http/Controllers/SocietyAdmin/CommunityPostController.php:13
* @route '/societies/{society}/community'
*/
index.get = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CommunityPostController::index
* @see app/Http/Controllers/SocietyAdmin/CommunityPostController.php:13
* @route '/societies/{society}/community'
*/
index.head = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CommunityPostController::index
* @see app/Http/Controllers/SocietyAdmin/CommunityPostController.php:13
* @route '/societies/{society}/community'
*/
const indexForm = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CommunityPostController::index
* @see app/Http/Controllers/SocietyAdmin/CommunityPostController.php:13
* @route '/societies/{society}/community'
*/
indexForm.get = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CommunityPostController::index
* @see app/Http/Controllers/SocietyAdmin/CommunityPostController.php:13
* @route '/societies/{society}/community'
*/
indexForm.head = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\CommunityPostController::destroy
* @see app/Http/Controllers/SocietyAdmin/CommunityPostController.php:29
* @route '/societies/{society}/community/{community}'
*/
export const destroy = (args: { society: string | number, community: string | number } | [society: string | number, community: string | number ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/societies/{society}/community/{community}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\CommunityPostController::destroy
* @see app/Http/Controllers/SocietyAdmin/CommunityPostController.php:29
* @route '/societies/{society}/community/{community}'
*/
destroy.url = (args: { society: string | number, community: string | number } | [society: string | number, community: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            community: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: args.society,
        community: args.community,
    }

    return destroy.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{community}', parsedArgs.community.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\CommunityPostController::destroy
* @see app/Http/Controllers/SocietyAdmin/CommunityPostController.php:29
* @route '/societies/{society}/community/{community}'
*/
destroy.delete = (args: { society: string | number, community: string | number } | [society: string | number, community: string | number ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CommunityPostController::destroy
* @see app/Http/Controllers/SocietyAdmin/CommunityPostController.php:29
* @route '/societies/{society}/community/{community}'
*/
const destroyForm = (args: { society: string | number, community: string | number } | [society: string | number, community: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CommunityPostController::destroy
* @see app/Http/Controllers/SocietyAdmin/CommunityPostController.php:29
* @route '/societies/{society}/community/{community}'
*/
destroyForm.delete = (args: { society: string | number, community: string | number } | [society: string | number, community: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const CommunityPostController = { index, destroy }

export default CommunityPostController