import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::index
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:22
* @route '/societies/{society}/collectors/wallets'
*/
export const index = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/collectors/wallets',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::index
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:22
* @route '/societies/{society}/collectors/wallets'
*/
index.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::index
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:22
* @route '/societies/{society}/collectors/wallets'
*/
index.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::index
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:22
* @route '/societies/{society}/collectors/wallets'
*/
index.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::index
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:22
* @route '/societies/{society}/collectors/wallets'
*/
const indexForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::index
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:22
* @route '/societies/{society}/collectors/wallets'
*/
indexForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::index
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:22
* @route '/societies/{society}/collectors/wallets'
*/
indexForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::show
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:102
* @route '/societies/{society}/collectors/{collector}/wallet'
*/
export const show = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/collectors/{collector}/wallet',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::show
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:102
* @route '/societies/{society}/collectors/{collector}/wallet'
*/
show.url = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            collector: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        collector: args.collector,
    }

    return show.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{collector}', parsedArgs.collector.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::show
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:102
* @route '/societies/{society}/collectors/{collector}/wallet'
*/
show.get = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::show
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:102
* @route '/societies/{society}/collectors/{collector}/wallet'
*/
show.head = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::show
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:102
* @route '/societies/{society}/collectors/{collector}/wallet'
*/
const showForm = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::show
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:102
* @route '/societies/{society}/collectors/{collector}/wallet'
*/
showForm.get = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::show
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:102
* @route '/societies/{society}/collectors/{collector}/wallet'
*/
showForm.head = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::recordHandover
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:239
* @route '/societies/{society}/collectors/{collector}/handover'
*/
export const recordHandover = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: recordHandover.url(args, options),
    method: 'post',
})

recordHandover.definition = {
    methods: ["post"],
    url: '/societies/{society}/collectors/{collector}/handover',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::recordHandover
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:239
* @route '/societies/{society}/collectors/{collector}/handover'
*/
recordHandover.url = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            collector: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        collector: args.collector,
    }

    return recordHandover.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{collector}', parsedArgs.collector.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::recordHandover
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:239
* @route '/societies/{society}/collectors/{collector}/handover'
*/
recordHandover.post = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: recordHandover.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::recordHandover
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:239
* @route '/societies/{society}/collectors/{collector}/handover'
*/
const recordHandoverForm = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: recordHandover.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\CollectorWalletController::recordHandover
* @see app/Http/Controllers/SocietyAdmin/CollectorWalletController.php:239
* @route '/societies/{society}/collectors/{collector}/handover'
*/
recordHandoverForm.post = (args: { society: number | { id: number }, collector: string | number } | [society: number | { id: number }, collector: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: recordHandover.url(args, options),
    method: 'post',
})

recordHandover.form = recordHandoverForm

const CollectorWalletController = { index, show, recordHandover }

export default CollectorWalletController