import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::index
* @see app/Http/Controllers/SocietyAdmin/BillController.php:24
* @route '/societies/{society}/bills'
*/
export const index = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/bills',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::index
* @see app/Http/Controllers/SocietyAdmin/BillController.php:24
* @route '/societies/{society}/bills'
*/
index.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::index
* @see app/Http/Controllers/SocietyAdmin/BillController.php:24
* @route '/societies/{society}/bills'
*/
index.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::index
* @see app/Http/Controllers/SocietyAdmin/BillController.php:24
* @route '/societies/{society}/bills'
*/
index.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::index
* @see app/Http/Controllers/SocietyAdmin/BillController.php:24
* @route '/societies/{society}/bills'
*/
const indexForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::index
* @see app/Http/Controllers/SocietyAdmin/BillController.php:24
* @route '/societies/{society}/bills'
*/
indexForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::index
* @see app/Http/Controllers/SocietyAdmin/BillController.php:24
* @route '/societies/{society}/bills'
*/
indexForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::create
* @see app/Http/Controllers/SocietyAdmin/BillController.php:113
* @route '/societies/{society}/bills/create'
*/
export const create = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/bills/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::create
* @see app/Http/Controllers/SocietyAdmin/BillController.php:113
* @route '/societies/{society}/bills/create'
*/
create.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return create.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::create
* @see app/Http/Controllers/SocietyAdmin/BillController.php:113
* @route '/societies/{society}/bills/create'
*/
create.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::create
* @see app/Http/Controllers/SocietyAdmin/BillController.php:113
* @route '/societies/{society}/bills/create'
*/
create.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::create
* @see app/Http/Controllers/SocietyAdmin/BillController.php:113
* @route '/societies/{society}/bills/create'
*/
const createForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::create
* @see app/Http/Controllers/SocietyAdmin/BillController.php:113
* @route '/societies/{society}/bills/create'
*/
createForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::create
* @see app/Http/Controllers/SocietyAdmin/BillController.php:113
* @route '/societies/{society}/bills/create'
*/
createForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::store
* @see app/Http/Controllers/SocietyAdmin/BillController.php:148
* @route '/societies/{society}/bills'
*/
export const store = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/societies/{society}/bills',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::store
* @see app/Http/Controllers/SocietyAdmin/BillController.php:148
* @route '/societies/{society}/bills'
*/
store.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return store.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::store
* @see app/Http/Controllers/SocietyAdmin/BillController.php:148
* @route '/societies/{society}/bills'
*/
store.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::store
* @see app/Http/Controllers/SocietyAdmin/BillController.php:148
* @route '/societies/{society}/bills'
*/
const storeForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::store
* @see app/Http/Controllers/SocietyAdmin/BillController.php:148
* @route '/societies/{society}/bills'
*/
storeForm.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::show
* @see app/Http/Controllers/SocietyAdmin/BillController.php:251
* @route '/societies/{society}/bills/{bill}'
*/
export const show = (args: { society: number | { id: number }, bill: number | { id: number } } | [society: number | { id: number }, bill: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/bills/{bill}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::show
* @see app/Http/Controllers/SocietyAdmin/BillController.php:251
* @route '/societies/{society}/bills/{bill}'
*/
show.url = (args: { society: number | { id: number }, bill: number | { id: number } } | [society: number | { id: number }, bill: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            bill: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        bill: typeof args.bill === 'object'
        ? args.bill.id
        : args.bill,
    }

    return show.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{bill}', parsedArgs.bill.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::show
* @see app/Http/Controllers/SocietyAdmin/BillController.php:251
* @route '/societies/{society}/bills/{bill}'
*/
show.get = (args: { society: number | { id: number }, bill: number | { id: number } } | [society: number | { id: number }, bill: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::show
* @see app/Http/Controllers/SocietyAdmin/BillController.php:251
* @route '/societies/{society}/bills/{bill}'
*/
show.head = (args: { society: number | { id: number }, bill: number | { id: number } } | [society: number | { id: number }, bill: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::show
* @see app/Http/Controllers/SocietyAdmin/BillController.php:251
* @route '/societies/{society}/bills/{bill}'
*/
const showForm = (args: { society: number | { id: number }, bill: number | { id: number } } | [society: number | { id: number }, bill: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::show
* @see app/Http/Controllers/SocietyAdmin/BillController.php:251
* @route '/societies/{society}/bills/{bill}'
*/
showForm.get = (args: { society: number | { id: number }, bill: number | { id: number } } | [society: number | { id: number }, bill: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::show
* @see app/Http/Controllers/SocietyAdmin/BillController.php:251
* @route '/societies/{society}/bills/{bill}'
*/
showForm.head = (args: { society: number | { id: number }, bill: number | { id: number } } | [society: number | { id: number }, bill: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::update
* @see app/Http/Controllers/SocietyAdmin/BillController.php:283
* @route '/societies/{society}/bills/{bill}'
*/
export const update = (args: { society: number | { id: number }, bill: number | { id: number } } | [society: number | { id: number }, bill: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/societies/{society}/bills/{bill}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::update
* @see app/Http/Controllers/SocietyAdmin/BillController.php:283
* @route '/societies/{society}/bills/{bill}'
*/
update.url = (args: { society: number | { id: number }, bill: number | { id: number } } | [society: number | { id: number }, bill: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            bill: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        bill: typeof args.bill === 'object'
        ? args.bill.id
        : args.bill,
    }

    return update.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{bill}', parsedArgs.bill.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::update
* @see app/Http/Controllers/SocietyAdmin/BillController.php:283
* @route '/societies/{society}/bills/{bill}'
*/
update.put = (args: { society: number | { id: number }, bill: number | { id: number } } | [society: number | { id: number }, bill: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::update
* @see app/Http/Controllers/SocietyAdmin/BillController.php:283
* @route '/societies/{society}/bills/{bill}'
*/
update.patch = (args: { society: number | { id: number }, bill: number | { id: number } } | [society: number | { id: number }, bill: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::update
* @see app/Http/Controllers/SocietyAdmin/BillController.php:283
* @route '/societies/{society}/bills/{bill}'
*/
const updateForm = (args: { society: number | { id: number }, bill: number | { id: number } } | [society: number | { id: number }, bill: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::update
* @see app/Http/Controllers/SocietyAdmin/BillController.php:283
* @route '/societies/{society}/bills/{bill}'
*/
updateForm.put = (args: { society: number | { id: number }, bill: number | { id: number } } | [society: number | { id: number }, bill: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::update
* @see app/Http/Controllers/SocietyAdmin/BillController.php:283
* @route '/societies/{society}/bills/{bill}'
*/
updateForm.patch = (args: { society: number | { id: number }, bill: number | { id: number } } | [society: number | { id: number }, bill: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PATCH',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::revise
* @see app/Http/Controllers/SocietyAdmin/BillController.php:0
* @route '/societies/{society}/bills/{bill}/revise'
*/
export const revise = (args: { society: string | number, bill: string | number } | [society: string | number, bill: string | number ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: revise.url(args, options),
    method: 'post',
})

revise.definition = {
    methods: ["post"],
    url: '/societies/{society}/bills/{bill}/revise',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::revise
* @see app/Http/Controllers/SocietyAdmin/BillController.php:0
* @route '/societies/{society}/bills/{bill}/revise'
*/
revise.url = (args: { society: string | number, bill: string | number } | [society: string | number, bill: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            bill: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: args.society,
        bill: args.bill,
    }

    return revise.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{bill}', parsedArgs.bill.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::revise
* @see app/Http/Controllers/SocietyAdmin/BillController.php:0
* @route '/societies/{society}/bills/{bill}/revise'
*/
revise.post = (args: { society: string | number, bill: string | number } | [society: string | number, bill: string | number ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: revise.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::revise
* @see app/Http/Controllers/SocietyAdmin/BillController.php:0
* @route '/societies/{society}/bills/{bill}/revise'
*/
const reviseForm = (args: { society: string | number, bill: string | number } | [society: string | number, bill: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: revise.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::revise
* @see app/Http/Controllers/SocietyAdmin/BillController.php:0
* @route '/societies/{society}/bills/{bill}/revise'
*/
reviseForm.post = (args: { society: string | number, bill: string | number } | [society: string | number, bill: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: revise.url(args, options),
    method: 'post',
})

revise.form = reviseForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::approve
* @see app/Http/Controllers/SocietyAdmin/BillController.php:327
* @route '/societies/{society}/bills/approve'
*/
export const approve = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: approve.url(args, options),
    method: 'post',
})

approve.definition = {
    methods: ["post"],
    url: '/societies/{society}/bills/approve',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::approve
* @see app/Http/Controllers/SocietyAdmin/BillController.php:327
* @route '/societies/{society}/bills/approve'
*/
approve.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return approve.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::approve
* @see app/Http/Controllers/SocietyAdmin/BillController.php:327
* @route '/societies/{society}/bills/approve'
*/
approve.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: approve.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::approve
* @see app/Http/Controllers/SocietyAdmin/BillController.php:327
* @route '/societies/{society}/bills/approve'
*/
const approveForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: approve.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BillController::approve
* @see app/Http/Controllers/SocietyAdmin/BillController.php:327
* @route '/societies/{society}/bills/approve'
*/
approveForm.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: approve.url(args, options),
    method: 'post',
})

approve.form = approveForm

const BillController = { index, create, store, show, update, revise, approve }

export default BillController