import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::index
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:22
* @route '/societies/{society}/bank-accounts'
*/
export const index = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/bank-accounts',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::index
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:22
* @route '/societies/{society}/bank-accounts'
*/
index.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::index
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:22
* @route '/societies/{society}/bank-accounts'
*/
index.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::index
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:22
* @route '/societies/{society}/bank-accounts'
*/
index.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::index
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:22
* @route '/societies/{society}/bank-accounts'
*/
const indexForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::index
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:22
* @route '/societies/{society}/bank-accounts'
*/
indexForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::index
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:22
* @route '/societies/{society}/bank-accounts'
*/
indexForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::create
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:75
* @route '/societies/{society}/bank-accounts/create'
*/
export const create = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/bank-accounts/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::create
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:75
* @route '/societies/{society}/bank-accounts/create'
*/
create.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return create.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::create
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:75
* @route '/societies/{society}/bank-accounts/create'
*/
create.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::create
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:75
* @route '/societies/{society}/bank-accounts/create'
*/
create.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::create
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:75
* @route '/societies/{society}/bank-accounts/create'
*/
const createForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::create
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:75
* @route '/societies/{society}/bank-accounts/create'
*/
createForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::create
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:75
* @route '/societies/{society}/bank-accounts/create'
*/
createForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::store
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:91
* @route '/societies/{society}/bank-accounts'
*/
export const store = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/societies/{society}/bank-accounts',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::store
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:91
* @route '/societies/{society}/bank-accounts'
*/
store.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return store.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::store
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:91
* @route '/societies/{society}/bank-accounts'
*/
store.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::store
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:91
* @route '/societies/{society}/bank-accounts'
*/
const storeForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::store
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:91
* @route '/societies/{society}/bank-accounts'
*/
storeForm.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::edit
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:118
* @route '/societies/{society}/bank-accounts/{bank_account}/edit'
*/
export const edit = (args: { society: number | { id: number }, bank_account: string | number } | [society: number | { id: number }, bank_account: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/bank-accounts/{bank_account}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::edit
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:118
* @route '/societies/{society}/bank-accounts/{bank_account}/edit'
*/
edit.url = (args: { society: number | { id: number }, bank_account: string | number } | [society: number | { id: number }, bank_account: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            bank_account: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        bank_account: args.bank_account,
    }

    return edit.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{bank_account}', parsedArgs.bank_account.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::edit
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:118
* @route '/societies/{society}/bank-accounts/{bank_account}/edit'
*/
edit.get = (args: { society: number | { id: number }, bank_account: string | number } | [society: number | { id: number }, bank_account: string | number ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::edit
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:118
* @route '/societies/{society}/bank-accounts/{bank_account}/edit'
*/
edit.head = (args: { society: number | { id: number }, bank_account: string | number } | [society: number | { id: number }, bank_account: string | number ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::edit
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:118
* @route '/societies/{society}/bank-accounts/{bank_account}/edit'
*/
const editForm = (args: { society: number | { id: number }, bank_account: string | number } | [society: number | { id: number }, bank_account: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::edit
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:118
* @route '/societies/{society}/bank-accounts/{bank_account}/edit'
*/
editForm.get = (args: { society: number | { id: number }, bank_account: string | number } | [society: number | { id: number }, bank_account: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::edit
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:118
* @route '/societies/{society}/bank-accounts/{bank_account}/edit'
*/
editForm.head = (args: { society: number | { id: number }, bank_account: string | number } | [society: number | { id: number }, bank_account: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::update
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:137
* @route '/societies/{society}/bank-accounts/{bank_account}'
*/
export const update = (args: { society: number | { id: number }, bank_account: string | number } | [society: number | { id: number }, bank_account: string | number ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/societies/{society}/bank-accounts/{bank_account}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::update
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:137
* @route '/societies/{society}/bank-accounts/{bank_account}'
*/
update.url = (args: { society: number | { id: number }, bank_account: string | number } | [society: number | { id: number }, bank_account: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            bank_account: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        bank_account: args.bank_account,
    }

    return update.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{bank_account}', parsedArgs.bank_account.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::update
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:137
* @route '/societies/{society}/bank-accounts/{bank_account}'
*/
update.put = (args: { society: number | { id: number }, bank_account: string | number } | [society: number | { id: number }, bank_account: string | number ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::update
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:137
* @route '/societies/{society}/bank-accounts/{bank_account}'
*/
update.patch = (args: { society: number | { id: number }, bank_account: string | number } | [society: number | { id: number }, bank_account: string | number ], options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::update
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:137
* @route '/societies/{society}/bank-accounts/{bank_account}'
*/
const updateForm = (args: { society: number | { id: number }, bank_account: string | number } | [society: number | { id: number }, bank_account: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::update
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:137
* @route '/societies/{society}/bank-accounts/{bank_account}'
*/
updateForm.put = (args: { society: number | { id: number }, bank_account: string | number } | [society: number | { id: number }, bank_account: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::update
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:137
* @route '/societies/{society}/bank-accounts/{bank_account}'
*/
updateForm.patch = (args: { society: number | { id: number }, bank_account: string | number } | [society: number | { id: number }, bank_account: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PATCH',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::updateBalance
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:179
* @route '/societies/{society}/bank-accounts/{bankAccount}/update-balance'
*/
export const updateBalance = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: updateBalance.url(args, options),
    method: 'post',
})

updateBalance.definition = {
    methods: ["post"],
    url: '/societies/{society}/bank-accounts/{bankAccount}/update-balance',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::updateBalance
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:179
* @route '/societies/{society}/bank-accounts/{bankAccount}/update-balance'
*/
updateBalance.url = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            bankAccount: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        bankAccount: typeof args.bankAccount === 'object'
        ? args.bankAccount.id
        : args.bankAccount,
    }

    return updateBalance.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{bankAccount}', parsedArgs.bankAccount.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::updateBalance
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:179
* @route '/societies/{society}/bank-accounts/{bankAccount}/update-balance'
*/
updateBalance.post = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: updateBalance.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::updateBalance
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:179
* @route '/societies/{society}/bank-accounts/{bankAccount}/update-balance'
*/
const updateBalanceForm = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateBalance.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::updateBalance
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:179
* @route '/societies/{society}/bank-accounts/{bankAccount}/update-balance'
*/
updateBalanceForm.post = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateBalance.url(args, options),
    method: 'post',
})

updateBalance.form = updateBalanceForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::transactions
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:203
* @route '/societies/{society}/bank-accounts/{bankAccount}/transactions'
*/
export const transactions = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: transactions.url(args, options),
    method: 'get',
})

transactions.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/bank-accounts/{bankAccount}/transactions',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::transactions
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:203
* @route '/societies/{society}/bank-accounts/{bankAccount}/transactions'
*/
transactions.url = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            bankAccount: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        bankAccount: typeof args.bankAccount === 'object'
        ? args.bankAccount.id
        : args.bankAccount,
    }

    return transactions.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{bankAccount}', parsedArgs.bankAccount.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::transactions
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:203
* @route '/societies/{society}/bank-accounts/{bankAccount}/transactions'
*/
transactions.get = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: transactions.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::transactions
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:203
* @route '/societies/{society}/bank-accounts/{bankAccount}/transactions'
*/
transactions.head = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: transactions.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::transactions
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:203
* @route '/societies/{society}/bank-accounts/{bankAccount}/transactions'
*/
const transactionsForm = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: transactions.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::transactions
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:203
* @route '/societies/{society}/bank-accounts/{bankAccount}/transactions'
*/
transactionsForm.get = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: transactions.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::transactions
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:203
* @route '/societies/{society}/bank-accounts/{bankAccount}/transactions'
*/
transactionsForm.head = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: transactions.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

transactions.form = transactionsForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::exportMethod
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:261
* @route '/societies/{society}/bank-accounts/{bankAccount}/export'
*/
export const exportMethod = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: exportMethod.url(args, options),
    method: 'get',
})

exportMethod.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/bank-accounts/{bankAccount}/export',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::exportMethod
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:261
* @route '/societies/{society}/bank-accounts/{bankAccount}/export'
*/
exportMethod.url = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            bankAccount: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        bankAccount: typeof args.bankAccount === 'object'
        ? args.bankAccount.id
        : args.bankAccount,
    }

    return exportMethod.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{bankAccount}', parsedArgs.bankAccount.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::exportMethod
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:261
* @route '/societies/{society}/bank-accounts/{bankAccount}/export'
*/
exportMethod.get = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: exportMethod.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::exportMethod
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:261
* @route '/societies/{society}/bank-accounts/{bankAccount}/export'
*/
exportMethod.head = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: exportMethod.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::exportMethod
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:261
* @route '/societies/{society}/bank-accounts/{bankAccount}/export'
*/
const exportMethodForm = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: exportMethod.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::exportMethod
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:261
* @route '/societies/{society}/bank-accounts/{bankAccount}/export'
*/
exportMethodForm.get = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: exportMethod.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::exportMethod
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:261
* @route '/societies/{society}/bank-accounts/{bankAccount}/export'
*/
exportMethodForm.head = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: exportMethod.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

exportMethod.form = exportMethodForm

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::reconcile
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:346
* @route '/societies/{society}/bank-accounts/{bankAccount}/reconcile'
*/
export const reconcile = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: reconcile.url(args, options),
    method: 'post',
})

reconcile.definition = {
    methods: ["post"],
    url: '/societies/{society}/bank-accounts/{bankAccount}/reconcile',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::reconcile
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:346
* @route '/societies/{society}/bank-accounts/{bankAccount}/reconcile'
*/
reconcile.url = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            bankAccount: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        bankAccount: typeof args.bankAccount === 'object'
        ? args.bankAccount.id
        : args.bankAccount,
    }

    return reconcile.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{bankAccount}', parsedArgs.bankAccount.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::reconcile
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:346
* @route '/societies/{society}/bank-accounts/{bankAccount}/reconcile'
*/
reconcile.post = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: reconcile.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::reconcile
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:346
* @route '/societies/{society}/bank-accounts/{bankAccount}/reconcile'
*/
const reconcileForm = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: reconcile.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\BankAccountController::reconcile
* @see app/Http/Controllers/SocietyAdmin/BankAccountController.php:346
* @route '/societies/{society}/bank-accounts/{bankAccount}/reconcile'
*/
reconcileForm.post = (args: { society: number | { id: number }, bankAccount: number | { id: number } } | [society: number | { id: number }, bankAccount: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: reconcile.url(args, options),
    method: 'post',
})

reconcile.form = reconcileForm

const BankAccountController = { index, create, store, edit, update, updateBalance, transactions, exportMethod, reconcile, export: exportMethod }

export default BankAccountController