import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::index
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:23
* @route '/societies/{society}/announcements'
*/
export const index = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/announcements',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::index
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:23
* @route '/societies/{society}/announcements'
*/
index.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return index.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::index
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:23
* @route '/societies/{society}/announcements'
*/
index.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::index
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:23
* @route '/societies/{society}/announcements'
*/
index.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::index
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:23
* @route '/societies/{society}/announcements'
*/
const indexForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::index
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:23
* @route '/societies/{society}/announcements'
*/
indexForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::index
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:23
* @route '/societies/{society}/announcements'
*/
indexForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::create
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:92
* @route '/societies/{society}/announcements/create'
*/
export const create = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/announcements/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::create
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:92
* @route '/societies/{society}/announcements/create'
*/
create.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return create.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::create
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:92
* @route '/societies/{society}/announcements/create'
*/
create.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::create
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:92
* @route '/societies/{society}/announcements/create'
*/
create.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::create
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:92
* @route '/societies/{society}/announcements/create'
*/
const createForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::create
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:92
* @route '/societies/{society}/announcements/create'
*/
createForm.get = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::create
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:92
* @route '/societies/{society}/announcements/create'
*/
createForm.head = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::store
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:116
* @route '/societies/{society}/announcements'
*/
export const store = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/societies/{society}/announcements',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::store
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:116
* @route '/societies/{society}/announcements'
*/
store.url = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { society: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
    }

    return store.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::store
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:116
* @route '/societies/{society}/announcements'
*/
store.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::store
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:116
* @route '/societies/{society}/announcements'
*/
const storeForm = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::store
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:116
* @route '/societies/{society}/announcements'
*/
storeForm.post = (args: { society: number | { id: number } } | [society: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::edit
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:161
* @route '/societies/{society}/announcements/{announcement}/edit'
*/
export const edit = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/announcements/{announcement}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::edit
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:161
* @route '/societies/{society}/announcements/{announcement}/edit'
*/
edit.url = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            announcement: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        announcement: typeof args.announcement === 'object'
        ? args.announcement.id
        : args.announcement,
    }

    return edit.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{announcement}', parsedArgs.announcement.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::edit
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:161
* @route '/societies/{society}/announcements/{announcement}/edit'
*/
edit.get = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::edit
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:161
* @route '/societies/{society}/announcements/{announcement}/edit'
*/
edit.head = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::edit
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:161
* @route '/societies/{society}/announcements/{announcement}/edit'
*/
const editForm = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::edit
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:161
* @route '/societies/{society}/announcements/{announcement}/edit'
*/
editForm.get = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::edit
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:161
* @route '/societies/{society}/announcements/{announcement}/edit'
*/
editForm.head = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::update
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:193
* @route '/societies/{society}/announcements/{announcement}'
*/
export const update = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/societies/{society}/announcements/{announcement}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::update
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:193
* @route '/societies/{society}/announcements/{announcement}'
*/
update.url = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            announcement: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        announcement: typeof args.announcement === 'object'
        ? args.announcement.id
        : args.announcement,
    }

    return update.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{announcement}', parsedArgs.announcement.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::update
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:193
* @route '/societies/{society}/announcements/{announcement}'
*/
update.put = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::update
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:193
* @route '/societies/{society}/announcements/{announcement}'
*/
update.patch = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::update
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:193
* @route '/societies/{society}/announcements/{announcement}'
*/
const updateForm = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::update
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:193
* @route '/societies/{society}/announcements/{announcement}'
*/
updateForm.put = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::update
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:193
* @route '/societies/{society}/announcements/{announcement}'
*/
updateForm.patch = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PATCH',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::destroy
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:236
* @route '/societies/{society}/announcements/{announcement}'
*/
export const destroy = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/societies/{society}/announcements/{announcement}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::destroy
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:236
* @route '/societies/{society}/announcements/{announcement}'
*/
destroy.url = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            announcement: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        announcement: typeof args.announcement === 'object'
        ? args.announcement.id
        : args.announcement,
    }

    return destroy.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{announcement}', parsedArgs.announcement.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::destroy
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:236
* @route '/societies/{society}/announcements/{announcement}'
*/
destroy.delete = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::destroy
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:236
* @route '/societies/{society}/announcements/{announcement}'
*/
const destroyForm = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::destroy
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:236
* @route '/societies/{society}/announcements/{announcement}'
*/
destroyForm.delete = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::togglePublish
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:258
* @route '/societies/{society}/announcements/{announcement}/toggle-publish'
*/
export const togglePublish = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: togglePublish.url(args, options),
    method: 'post',
})

togglePublish.definition = {
    methods: ["post"],
    url: '/societies/{society}/announcements/{announcement}/toggle-publish',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::togglePublish
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:258
* @route '/societies/{society}/announcements/{announcement}/toggle-publish'
*/
togglePublish.url = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            announcement: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: typeof args.society === 'object'
        ? args.society.id
        : args.society,
        announcement: typeof args.announcement === 'object'
        ? args.announcement.id
        : args.announcement,
    }

    return togglePublish.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{announcement}', parsedArgs.announcement.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::togglePublish
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:258
* @route '/societies/{society}/announcements/{announcement}/toggle-publish'
*/
togglePublish.post = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: togglePublish.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::togglePublish
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:258
* @route '/societies/{society}/announcements/{announcement}/toggle-publish'
*/
const togglePublishForm = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: togglePublish.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SocietyAdmin\AnnouncementController::togglePublish
* @see app/Http/Controllers/SocietyAdmin/AnnouncementController.php:258
* @route '/societies/{society}/announcements/{announcement}/toggle-publish'
*/
togglePublishForm.post = (args: { society: number | { id: number }, announcement: number | { id: number } } | [society: number | { id: number }, announcement: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: togglePublish.url(args, options),
    method: 'post',
})

togglePublish.form = togglePublishForm

const AnnouncementController = { index, create, store, edit, update, destroy, togglePublish }

export default AnnouncementController