import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Resident\FacilityBookingController::createOrder
* @see app/Http/Controllers/Resident/FacilityBookingController.php:22
* @route '/api/resident/facility-bookings/create-order'
*/
export const createOrder = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: createOrder.url(options),
    method: 'post',
})

createOrder.definition = {
    methods: ["post"],
    url: '/api/resident/facility-bookings/create-order',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Resident\FacilityBookingController::createOrder
* @see app/Http/Controllers/Resident/FacilityBookingController.php:22
* @route '/api/resident/facility-bookings/create-order'
*/
createOrder.url = (options?: RouteQueryOptions) => {
    return createOrder.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Resident\FacilityBookingController::createOrder
* @see app/Http/Controllers/Resident/FacilityBookingController.php:22
* @route '/api/resident/facility-bookings/create-order'
*/
createOrder.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: createOrder.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Resident\FacilityBookingController::createOrder
* @see app/Http/Controllers/Resident/FacilityBookingController.php:22
* @route '/api/resident/facility-bookings/create-order'
*/
const createOrderForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: createOrder.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Resident\FacilityBookingController::createOrder
* @see app/Http/Controllers/Resident/FacilityBookingController.php:22
* @route '/api/resident/facility-bookings/create-order'
*/
createOrderForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: createOrder.url(options),
    method: 'post',
})

createOrder.form = createOrderForm

/**
* @see \App\Http\Controllers\Resident\FacilityBookingController::verifyPayment
* @see app/Http/Controllers/Resident/FacilityBookingController.php:146
* @route '/api/resident/facility-bookings/verify-payment'
*/
export const verifyPayment = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: verifyPayment.url(options),
    method: 'post',
})

verifyPayment.definition = {
    methods: ["post"],
    url: '/api/resident/facility-bookings/verify-payment',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Resident\FacilityBookingController::verifyPayment
* @see app/Http/Controllers/Resident/FacilityBookingController.php:146
* @route '/api/resident/facility-bookings/verify-payment'
*/
verifyPayment.url = (options?: RouteQueryOptions) => {
    return verifyPayment.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Resident\FacilityBookingController::verifyPayment
* @see app/Http/Controllers/Resident/FacilityBookingController.php:146
* @route '/api/resident/facility-bookings/verify-payment'
*/
verifyPayment.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: verifyPayment.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Resident\FacilityBookingController::verifyPayment
* @see app/Http/Controllers/Resident/FacilityBookingController.php:146
* @route '/api/resident/facility-bookings/verify-payment'
*/
const verifyPaymentForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: verifyPayment.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Resident\FacilityBookingController::verifyPayment
* @see app/Http/Controllers/Resident/FacilityBookingController.php:146
* @route '/api/resident/facility-bookings/verify-payment'
*/
verifyPaymentForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: verifyPayment.url(options),
    method: 'post',
})

verifyPayment.form = verifyPaymentForm

/**
* @see \App\Http\Controllers\Resident\FacilityBookingController::paymentFailed
* @see app/Http/Controllers/Resident/FacilityBookingController.php:269
* @route '/api/resident/facility-bookings/payment-failed'
*/
export const paymentFailed = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: paymentFailed.url(options),
    method: 'post',
})

paymentFailed.definition = {
    methods: ["post"],
    url: '/api/resident/facility-bookings/payment-failed',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Resident\FacilityBookingController::paymentFailed
* @see app/Http/Controllers/Resident/FacilityBookingController.php:269
* @route '/api/resident/facility-bookings/payment-failed'
*/
paymentFailed.url = (options?: RouteQueryOptions) => {
    return paymentFailed.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Resident\FacilityBookingController::paymentFailed
* @see app/Http/Controllers/Resident/FacilityBookingController.php:269
* @route '/api/resident/facility-bookings/payment-failed'
*/
paymentFailed.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: paymentFailed.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Resident\FacilityBookingController::paymentFailed
* @see app/Http/Controllers/Resident/FacilityBookingController.php:269
* @route '/api/resident/facility-bookings/payment-failed'
*/
const paymentFailedForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: paymentFailed.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Resident\FacilityBookingController::paymentFailed
* @see app/Http/Controllers/Resident/FacilityBookingController.php:269
* @route '/api/resident/facility-bookings/payment-failed'
*/
paymentFailedForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: paymentFailed.url(options),
    method: 'post',
})

paymentFailed.form = paymentFailedForm

const FacilityBookingController = { createOrder, verifyPayment, paymentFailed }

export default FacilityBookingController