import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\OnboardingController::store
* @see app/Http/Controllers/OnboardingController.php:26
* @route '/onboarding/society'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/onboarding/society',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\OnboardingController::store
* @see app/Http/Controllers/OnboardingController.php:26
* @route '/onboarding/society'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\OnboardingController::store
* @see app/Http/Controllers/OnboardingController.php:26
* @route '/onboarding/society'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\OnboardingController::store
* @see app/Http/Controllers/OnboardingController.php:26
* @route '/onboarding/society'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\OnboardingController::store
* @see app/Http/Controllers/OnboardingController.php:26
* @route '/onboarding/society'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\OnboardingController::createPaymentOrder
* @see app/Http/Controllers/OnboardingController.php:184
* @route '/onboarding/payment/create-order'
*/
export const createPaymentOrder = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: createPaymentOrder.url(options),
    method: 'post',
})

createPaymentOrder.definition = {
    methods: ["post"],
    url: '/onboarding/payment/create-order',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\OnboardingController::createPaymentOrder
* @see app/Http/Controllers/OnboardingController.php:184
* @route '/onboarding/payment/create-order'
*/
createPaymentOrder.url = (options?: RouteQueryOptions) => {
    return createPaymentOrder.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\OnboardingController::createPaymentOrder
* @see app/Http/Controllers/OnboardingController.php:184
* @route '/onboarding/payment/create-order'
*/
createPaymentOrder.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: createPaymentOrder.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\OnboardingController::createPaymentOrder
* @see app/Http/Controllers/OnboardingController.php:184
* @route '/onboarding/payment/create-order'
*/
const createPaymentOrderForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: createPaymentOrder.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\OnboardingController::createPaymentOrder
* @see app/Http/Controllers/OnboardingController.php:184
* @route '/onboarding/payment/create-order'
*/
createPaymentOrderForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: createPaymentOrder.url(options),
    method: 'post',
})

createPaymentOrder.form = createPaymentOrderForm

const OnboardingController = { store, createPaymentOrder }

export default OnboardingController