import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\VendorController::tickets
* @see app/Http/Controllers/Api/VendorController.php:20
* @route '/api/vendor/tickets'
*/
export const tickets = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: tickets.url(options),
    method: 'get',
})

tickets.definition = {
    methods: ["get","head"],
    url: '/api/vendor/tickets',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\VendorController::tickets
* @see app/Http/Controllers/Api/VendorController.php:20
* @route '/api/vendor/tickets'
*/
tickets.url = (options?: RouteQueryOptions) => {
    return tickets.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\VendorController::tickets
* @see app/Http/Controllers/Api/VendorController.php:20
* @route '/api/vendor/tickets'
*/
tickets.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: tickets.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\VendorController::tickets
* @see app/Http/Controllers/Api/VendorController.php:20
* @route '/api/vendor/tickets'
*/
tickets.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: tickets.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\VendorController::tickets
* @see app/Http/Controllers/Api/VendorController.php:20
* @route '/api/vendor/tickets'
*/
const ticketsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: tickets.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\VendorController::tickets
* @see app/Http/Controllers/Api/VendorController.php:20
* @route '/api/vendor/tickets'
*/
ticketsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: tickets.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\VendorController::tickets
* @see app/Http/Controllers/Api/VendorController.php:20
* @route '/api/vendor/tickets'
*/
ticketsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: tickets.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

tickets.form = ticketsForm

/**
* @see \App\Http\Controllers\Api\VendorController::updateTicket
* @see app/Http/Controllers/Api/VendorController.php:36
* @route '/api/vendor/tickets/{ticket}'
*/
export const updateTicket = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: updateTicket.url(args, options),
    method: 'put',
})

updateTicket.definition = {
    methods: ["put"],
    url: '/api/vendor/tickets/{ticket}',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\Api\VendorController::updateTicket
* @see app/Http/Controllers/Api/VendorController.php:36
* @route '/api/vendor/tickets/{ticket}'
*/
updateTicket.url = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { ticket: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { ticket: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            ticket: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        ticket: typeof args.ticket === 'object'
        ? args.ticket.id
        : args.ticket,
    }

    return updateTicket.definition.url
            .replace('{ticket}', parsedArgs.ticket.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\VendorController::updateTicket
* @see app/Http/Controllers/Api/VendorController.php:36
* @route '/api/vendor/tickets/{ticket}'
*/
updateTicket.put = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: updateTicket.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\Api\VendorController::updateTicket
* @see app/Http/Controllers/Api/VendorController.php:36
* @route '/api/vendor/tickets/{ticket}'
*/
const updateTicketForm = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateTicket.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\VendorController::updateTicket
* @see app/Http/Controllers/Api/VendorController.php:36
* @route '/api/vendor/tickets/{ticket}'
*/
updateTicketForm.put = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateTicket.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

updateTicket.form = updateTicketForm

const VendorController = { tickets, updateTicket }

export default VendorController