import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\TenantController::index
* @see app/Http/Controllers/Api/TenantController.php:18
* @route '/api/resident/tenants'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/api/resident/tenants',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\TenantController::index
* @see app/Http/Controllers/Api/TenantController.php:18
* @route '/api/resident/tenants'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\TenantController::index
* @see app/Http/Controllers/Api/TenantController.php:18
* @route '/api/resident/tenants'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\TenantController::index
* @see app/Http/Controllers/Api/TenantController.php:18
* @route '/api/resident/tenants'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\TenantController::index
* @see app/Http/Controllers/Api/TenantController.php:18
* @route '/api/resident/tenants'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\TenantController::index
* @see app/Http/Controllers/Api/TenantController.php:18
* @route '/api/resident/tenants'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\TenantController::index
* @see app/Http/Controllers/Api/TenantController.php:18
* @route '/api/resident/tenants'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\Api\TenantController::store
* @see app/Http/Controllers/Api/TenantController.php:34
* @route '/api/resident/tenants'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/api/resident/tenants',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\TenantController::store
* @see app/Http/Controllers/Api/TenantController.php:34
* @route '/api/resident/tenants'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\TenantController::store
* @see app/Http/Controllers/Api/TenantController.php:34
* @route '/api/resident/tenants'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\TenantController::store
* @see app/Http/Controllers/Api/TenantController.php:34
* @route '/api/resident/tenants'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\TenantController::store
* @see app/Http/Controllers/Api/TenantController.php:34
* @route '/api/resident/tenants'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\Api\TenantController::uploadDocument
* @see app/Http/Controllers/Api/TenantController.php:107
* @route '/api/resident/tenants/{id}/documents'
*/
export const uploadDocument = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: uploadDocument.url(args, options),
    method: 'post',
})

uploadDocument.definition = {
    methods: ["post"],
    url: '/api/resident/tenants/{id}/documents',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\TenantController::uploadDocument
* @see app/Http/Controllers/Api/TenantController.php:107
* @route '/api/resident/tenants/{id}/documents'
*/
uploadDocument.url = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { id: args }
    }

    if (Array.isArray(args)) {
        args = {
            id: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        id: args.id,
    }

    return uploadDocument.definition.url
            .replace('{id}', parsedArgs.id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\TenantController::uploadDocument
* @see app/Http/Controllers/Api/TenantController.php:107
* @route '/api/resident/tenants/{id}/documents'
*/
uploadDocument.post = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: uploadDocument.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\TenantController::uploadDocument
* @see app/Http/Controllers/Api/TenantController.php:107
* @route '/api/resident/tenants/{id}/documents'
*/
const uploadDocumentForm = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: uploadDocument.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\TenantController::uploadDocument
* @see app/Http/Controllers/Api/TenantController.php:107
* @route '/api/resident/tenants/{id}/documents'
*/
uploadDocumentForm.post = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: uploadDocument.url(args, options),
    method: 'post',
})

uploadDocument.form = uploadDocumentForm

/**
* @see \App\Http\Controllers\Api\TenantController::destroy
* @see app/Http/Controllers/Api/TenantController.php:150
* @route '/api/resident/tenants/{id}'
*/
export const destroy = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/api/resident/tenants/{id}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\Api\TenantController::destroy
* @see app/Http/Controllers/Api/TenantController.php:150
* @route '/api/resident/tenants/{id}'
*/
destroy.url = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { id: args }
    }

    if (Array.isArray(args)) {
        args = {
            id: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        id: args.id,
    }

    return destroy.definition.url
            .replace('{id}', parsedArgs.id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\TenantController::destroy
* @see app/Http/Controllers/Api/TenantController.php:150
* @route '/api/resident/tenants/{id}'
*/
destroy.delete = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\Api\TenantController::destroy
* @see app/Http/Controllers/Api/TenantController.php:150
* @route '/api/resident/tenants/{id}'
*/
const destroyForm = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\TenantController::destroy
* @see app/Http/Controllers/Api/TenantController.php:150
* @route '/api/resident/tenants/{id}'
*/
destroyForm.delete = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

const TenantController = { index, store, uploadDocument, destroy }

export default TenantController