import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::getPaymentGateways
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:19
* @route '/api/subscription/payment-gateways'
*/
export const getPaymentGateways = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getPaymentGateways.url(options),
    method: 'get',
})

getPaymentGateways.definition = {
    methods: ["get","head"],
    url: '/api/subscription/payment-gateways',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::getPaymentGateways
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:19
* @route '/api/subscription/payment-gateways'
*/
getPaymentGateways.url = (options?: RouteQueryOptions) => {
    return getPaymentGateways.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::getPaymentGateways
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:19
* @route '/api/subscription/payment-gateways'
*/
getPaymentGateways.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getPaymentGateways.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::getPaymentGateways
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:19
* @route '/api/subscription/payment-gateways'
*/
getPaymentGateways.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: getPaymentGateways.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::getPaymentGateways
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:19
* @route '/api/subscription/payment-gateways'
*/
const getPaymentGatewaysForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getPaymentGateways.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::getPaymentGateways
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:19
* @route '/api/subscription/payment-gateways'
*/
getPaymentGatewaysForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getPaymentGateways.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::getPaymentGateways
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:19
* @route '/api/subscription/payment-gateways'
*/
getPaymentGatewaysForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getPaymentGateways.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

getPaymentGateways.form = getPaymentGatewaysForm

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::createPaymentOrder
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:40
* @route '/api/subscription/create-payment-order'
*/
const createPaymentOrder6ad09f2fabcf8b64e1fd56f48c4a899a = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: createPaymentOrder6ad09f2fabcf8b64e1fd56f48c4a899a.url(options),
    method: 'post',
})

createPaymentOrder6ad09f2fabcf8b64e1fd56f48c4a899a.definition = {
    methods: ["post"],
    url: '/api/subscription/create-payment-order',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::createPaymentOrder
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:40
* @route '/api/subscription/create-payment-order'
*/
createPaymentOrder6ad09f2fabcf8b64e1fd56f48c4a899a.url = (options?: RouteQueryOptions) => {
    return createPaymentOrder6ad09f2fabcf8b64e1fd56f48c4a899a.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::createPaymentOrder
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:40
* @route '/api/subscription/create-payment-order'
*/
createPaymentOrder6ad09f2fabcf8b64e1fd56f48c4a899a.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: createPaymentOrder6ad09f2fabcf8b64e1fd56f48c4a899a.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::createPaymentOrder
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:40
* @route '/api/subscription/create-payment-order'
*/
const createPaymentOrder6ad09f2fabcf8b64e1fd56f48c4a899aForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: createPaymentOrder6ad09f2fabcf8b64e1fd56f48c4a899a.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::createPaymentOrder
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:40
* @route '/api/subscription/create-payment-order'
*/
createPaymentOrder6ad09f2fabcf8b64e1fd56f48c4a899aForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: createPaymentOrder6ad09f2fabcf8b64e1fd56f48c4a899a.url(options),
    method: 'post',
})

createPaymentOrder6ad09f2fabcf8b64e1fd56f48c4a899a.form = createPaymentOrder6ad09f2fabcf8b64e1fd56f48c4a899aForm
/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::createPaymentOrder
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:40
* @route '/subscription/create-payment-order'
*/
const createPaymentOrder77f1f7322169c1a7b8ff06d0738c7439 = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: createPaymentOrder77f1f7322169c1a7b8ff06d0738c7439.url(options),
    method: 'post',
})

createPaymentOrder77f1f7322169c1a7b8ff06d0738c7439.definition = {
    methods: ["post"],
    url: '/subscription/create-payment-order',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::createPaymentOrder
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:40
* @route '/subscription/create-payment-order'
*/
createPaymentOrder77f1f7322169c1a7b8ff06d0738c7439.url = (options?: RouteQueryOptions) => {
    return createPaymentOrder77f1f7322169c1a7b8ff06d0738c7439.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::createPaymentOrder
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:40
* @route '/subscription/create-payment-order'
*/
createPaymentOrder77f1f7322169c1a7b8ff06d0738c7439.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: createPaymentOrder77f1f7322169c1a7b8ff06d0738c7439.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::createPaymentOrder
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:40
* @route '/subscription/create-payment-order'
*/
const createPaymentOrder77f1f7322169c1a7b8ff06d0738c7439Form = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: createPaymentOrder77f1f7322169c1a7b8ff06d0738c7439.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::createPaymentOrder
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:40
* @route '/subscription/create-payment-order'
*/
createPaymentOrder77f1f7322169c1a7b8ff06d0738c7439Form.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: createPaymentOrder77f1f7322169c1a7b8ff06d0738c7439.url(options),
    method: 'post',
})

createPaymentOrder77f1f7322169c1a7b8ff06d0738c7439.form = createPaymentOrder77f1f7322169c1a7b8ff06d0738c7439Form

export const createPaymentOrder = {
    '/api/subscription/create-payment-order': createPaymentOrder6ad09f2fabcf8b64e1fd56f48c4a899a,
    '/subscription/create-payment-order': createPaymentOrder77f1f7322169c1a7b8ff06d0738c7439,
}

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::verifyPayment
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:209
* @route '/api/subscription/verify-payment'
*/
const verifyPayment01cdcd3f3d2c57d01435f359031bd683 = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: verifyPayment01cdcd3f3d2c57d01435f359031bd683.url(options),
    method: 'post',
})

verifyPayment01cdcd3f3d2c57d01435f359031bd683.definition = {
    methods: ["post"],
    url: '/api/subscription/verify-payment',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::verifyPayment
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:209
* @route '/api/subscription/verify-payment'
*/
verifyPayment01cdcd3f3d2c57d01435f359031bd683.url = (options?: RouteQueryOptions) => {
    return verifyPayment01cdcd3f3d2c57d01435f359031bd683.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::verifyPayment
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:209
* @route '/api/subscription/verify-payment'
*/
verifyPayment01cdcd3f3d2c57d01435f359031bd683.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: verifyPayment01cdcd3f3d2c57d01435f359031bd683.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::verifyPayment
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:209
* @route '/api/subscription/verify-payment'
*/
const verifyPayment01cdcd3f3d2c57d01435f359031bd683Form = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: verifyPayment01cdcd3f3d2c57d01435f359031bd683.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::verifyPayment
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:209
* @route '/api/subscription/verify-payment'
*/
verifyPayment01cdcd3f3d2c57d01435f359031bd683Form.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: verifyPayment01cdcd3f3d2c57d01435f359031bd683.url(options),
    method: 'post',
})

verifyPayment01cdcd3f3d2c57d01435f359031bd683.form = verifyPayment01cdcd3f3d2c57d01435f359031bd683Form
/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::verifyPayment
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:209
* @route '/subscription/verify-payment'
*/
const verifyPaymente4de38fc2a003bb7ec43f0bfddfd7981 = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: verifyPaymente4de38fc2a003bb7ec43f0bfddfd7981.url(options),
    method: 'post',
})

verifyPaymente4de38fc2a003bb7ec43f0bfddfd7981.definition = {
    methods: ["post"],
    url: '/subscription/verify-payment',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::verifyPayment
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:209
* @route '/subscription/verify-payment'
*/
verifyPaymente4de38fc2a003bb7ec43f0bfddfd7981.url = (options?: RouteQueryOptions) => {
    return verifyPaymente4de38fc2a003bb7ec43f0bfddfd7981.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::verifyPayment
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:209
* @route '/subscription/verify-payment'
*/
verifyPaymente4de38fc2a003bb7ec43f0bfddfd7981.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: verifyPaymente4de38fc2a003bb7ec43f0bfddfd7981.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::verifyPayment
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:209
* @route '/subscription/verify-payment'
*/
const verifyPaymente4de38fc2a003bb7ec43f0bfddfd7981Form = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: verifyPaymente4de38fc2a003bb7ec43f0bfddfd7981.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\SubscriptionPaymentController::verifyPayment
* @see app/Http/Controllers/Api/SubscriptionPaymentController.php:209
* @route '/subscription/verify-payment'
*/
verifyPaymente4de38fc2a003bb7ec43f0bfddfd7981Form.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: verifyPaymente4de38fc2a003bb7ec43f0bfddfd7981.url(options),
    method: 'post',
})

verifyPaymente4de38fc2a003bb7ec43f0bfddfd7981.form = verifyPaymente4de38fc2a003bb7ec43f0bfddfd7981Form

export const verifyPayment = {
    '/api/subscription/verify-payment': verifyPayment01cdcd3f3d2c57d01435f359031bd683,
    '/subscription/verify-payment': verifyPaymente4de38fc2a003bb7ec43f0bfddfd7981,
}

const SubscriptionPaymentController = { getPaymentGateways, createPaymentOrder, verifyPayment }

export default SubscriptionPaymentController