import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\ResidentController::bills
* @see app/Http/Controllers/Api/ResidentController.php:20
* @route '/api/resident/bills'
*/
export const bills = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: bills.url(options),
    method: 'get',
})

bills.definition = {
    methods: ["get","head"],
    url: '/api/resident/bills',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\ResidentController::bills
* @see app/Http/Controllers/Api/ResidentController.php:20
* @route '/api/resident/bills'
*/
bills.url = (options?: RouteQueryOptions) => {
    return bills.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\ResidentController::bills
* @see app/Http/Controllers/Api/ResidentController.php:20
* @route '/api/resident/bills'
*/
bills.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: bills.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::bills
* @see app/Http/Controllers/Api/ResidentController.php:20
* @route '/api/resident/bills'
*/
bills.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: bills.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::bills
* @see app/Http/Controllers/Api/ResidentController.php:20
* @route '/api/resident/bills'
*/
const billsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: bills.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::bills
* @see app/Http/Controllers/Api/ResidentController.php:20
* @route '/api/resident/bills'
*/
billsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: bills.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::bills
* @see app/Http/Controllers/Api/ResidentController.php:20
* @route '/api/resident/bills'
*/
billsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: bills.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

bills.form = billsForm

/**
* @see \App\Http\Controllers\Api\ResidentController::showBill
* @see app/Http/Controllers/Api/ResidentController.php:85
* @route '/api/resident/bills/{bill}'
*/
export const showBill = (args: { bill: number | { id: number } } | [bill: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: showBill.url(args, options),
    method: 'get',
})

showBill.definition = {
    methods: ["get","head"],
    url: '/api/resident/bills/{bill}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\ResidentController::showBill
* @see app/Http/Controllers/Api/ResidentController.php:85
* @route '/api/resident/bills/{bill}'
*/
showBill.url = (args: { bill: number | { id: number } } | [bill: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { bill: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { bill: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            bill: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        bill: typeof args.bill === 'object'
        ? args.bill.id
        : args.bill,
    }

    return showBill.definition.url
            .replace('{bill}', parsedArgs.bill.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\ResidentController::showBill
* @see app/Http/Controllers/Api/ResidentController.php:85
* @route '/api/resident/bills/{bill}'
*/
showBill.get = (args: { bill: number | { id: number } } | [bill: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: showBill.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::showBill
* @see app/Http/Controllers/Api/ResidentController.php:85
* @route '/api/resident/bills/{bill}'
*/
showBill.head = (args: { bill: number | { id: number } } | [bill: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: showBill.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::showBill
* @see app/Http/Controllers/Api/ResidentController.php:85
* @route '/api/resident/bills/{bill}'
*/
const showBillForm = (args: { bill: number | { id: number } } | [bill: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: showBill.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::showBill
* @see app/Http/Controllers/Api/ResidentController.php:85
* @route '/api/resident/bills/{bill}'
*/
showBillForm.get = (args: { bill: number | { id: number } } | [bill: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: showBill.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::showBill
* @see app/Http/Controllers/Api/ResidentController.php:85
* @route '/api/resident/bills/{bill}'
*/
showBillForm.head = (args: { bill: number | { id: number } } | [bill: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: showBill.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

showBill.form = showBillForm

/**
* @see \App\Http\Controllers\Api\ResidentController::createOrder
* @see app/Http/Controllers/Api/ResidentController.php:526
* @route '/api/resident/bills/create-order'
*/
export const createOrder = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: createOrder.url(options),
    method: 'post',
})

createOrder.definition = {
    methods: ["post"],
    url: '/api/resident/bills/create-order',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\ResidentController::createOrder
* @see app/Http/Controllers/Api/ResidentController.php:526
* @route '/api/resident/bills/create-order'
*/
createOrder.url = (options?: RouteQueryOptions) => {
    return createOrder.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\ResidentController::createOrder
* @see app/Http/Controllers/Api/ResidentController.php:526
* @route '/api/resident/bills/create-order'
*/
createOrder.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: createOrder.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::createOrder
* @see app/Http/Controllers/Api/ResidentController.php:526
* @route '/api/resident/bills/create-order'
*/
const createOrderForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: createOrder.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::createOrder
* @see app/Http/Controllers/Api/ResidentController.php:526
* @route '/api/resident/bills/create-order'
*/
createOrderForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: createOrder.url(options),
    method: 'post',
})

createOrder.form = createOrderForm

/**
* @see \App\Http\Controllers\Api\ResidentController::verifyPayment
* @see app/Http/Controllers/Api/ResidentController.php:623
* @route '/api/resident/bills/verify-payment'
*/
export const verifyPayment = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: verifyPayment.url(options),
    method: 'post',
})

verifyPayment.definition = {
    methods: ["post"],
    url: '/api/resident/bills/verify-payment',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\ResidentController::verifyPayment
* @see app/Http/Controllers/Api/ResidentController.php:623
* @route '/api/resident/bills/verify-payment'
*/
verifyPayment.url = (options?: RouteQueryOptions) => {
    return verifyPayment.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\ResidentController::verifyPayment
* @see app/Http/Controllers/Api/ResidentController.php:623
* @route '/api/resident/bills/verify-payment'
*/
verifyPayment.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: verifyPayment.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::verifyPayment
* @see app/Http/Controllers/Api/ResidentController.php:623
* @route '/api/resident/bills/verify-payment'
*/
const verifyPaymentForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: verifyPayment.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::verifyPayment
* @see app/Http/Controllers/Api/ResidentController.php:623
* @route '/api/resident/bills/verify-payment'
*/
verifyPaymentForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: verifyPayment.url(options),
    method: 'post',
})

verifyPayment.form = verifyPaymentForm

/**
* @see \App\Http\Controllers\Api\ResidentController::tickets
* @see app/Http/Controllers/Api/ResidentController.php:123
* @route '/api/resident/tickets'
*/
export const tickets = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: tickets.url(options),
    method: 'get',
})

tickets.definition = {
    methods: ["get","head"],
    url: '/api/resident/tickets',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\ResidentController::tickets
* @see app/Http/Controllers/Api/ResidentController.php:123
* @route '/api/resident/tickets'
*/
tickets.url = (options?: RouteQueryOptions) => {
    return tickets.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\ResidentController::tickets
* @see app/Http/Controllers/Api/ResidentController.php:123
* @route '/api/resident/tickets'
*/
tickets.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: tickets.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::tickets
* @see app/Http/Controllers/Api/ResidentController.php:123
* @route '/api/resident/tickets'
*/
tickets.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: tickets.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::tickets
* @see app/Http/Controllers/Api/ResidentController.php:123
* @route '/api/resident/tickets'
*/
const ticketsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: tickets.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::tickets
* @see app/Http/Controllers/Api/ResidentController.php:123
* @route '/api/resident/tickets'
*/
ticketsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: tickets.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::tickets
* @see app/Http/Controllers/Api/ResidentController.php:123
* @route '/api/resident/tickets'
*/
ticketsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: tickets.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

tickets.form = ticketsForm

/**
* @see \App\Http\Controllers\Api\ResidentController::storeTicket
* @see app/Http/Controllers/Api/ResidentController.php:162
* @route '/api/resident/tickets'
*/
export const storeTicket = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: storeTicket.url(options),
    method: 'post',
})

storeTicket.definition = {
    methods: ["post"],
    url: '/api/resident/tickets',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\ResidentController::storeTicket
* @see app/Http/Controllers/Api/ResidentController.php:162
* @route '/api/resident/tickets'
*/
storeTicket.url = (options?: RouteQueryOptions) => {
    return storeTicket.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\ResidentController::storeTicket
* @see app/Http/Controllers/Api/ResidentController.php:162
* @route '/api/resident/tickets'
*/
storeTicket.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: storeTicket.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::storeTicket
* @see app/Http/Controllers/Api/ResidentController.php:162
* @route '/api/resident/tickets'
*/
const storeTicketForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: storeTicket.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::storeTicket
* @see app/Http/Controllers/Api/ResidentController.php:162
* @route '/api/resident/tickets'
*/
storeTicketForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: storeTicket.url(options),
    method: 'post',
})

storeTicket.form = storeTicketForm

/**
* @see \App\Http\Controllers\Api\ResidentController::showTicket
* @see app/Http/Controllers/Api/ResidentController.php:217
* @route '/api/resident/tickets/{ticket}'
*/
export const showTicket = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: showTicket.url(args, options),
    method: 'get',
})

showTicket.definition = {
    methods: ["get","head"],
    url: '/api/resident/tickets/{ticket}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\ResidentController::showTicket
* @see app/Http/Controllers/Api/ResidentController.php:217
* @route '/api/resident/tickets/{ticket}'
*/
showTicket.url = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { ticket: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { ticket: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            ticket: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        ticket: typeof args.ticket === 'object'
        ? args.ticket.id
        : args.ticket,
    }

    return showTicket.definition.url
            .replace('{ticket}', parsedArgs.ticket.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\ResidentController::showTicket
* @see app/Http/Controllers/Api/ResidentController.php:217
* @route '/api/resident/tickets/{ticket}'
*/
showTicket.get = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: showTicket.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::showTicket
* @see app/Http/Controllers/Api/ResidentController.php:217
* @route '/api/resident/tickets/{ticket}'
*/
showTicket.head = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: showTicket.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::showTicket
* @see app/Http/Controllers/Api/ResidentController.php:217
* @route '/api/resident/tickets/{ticket}'
*/
const showTicketForm = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: showTicket.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::showTicket
* @see app/Http/Controllers/Api/ResidentController.php:217
* @route '/api/resident/tickets/{ticket}'
*/
showTicketForm.get = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: showTicket.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::showTicket
* @see app/Http/Controllers/Api/ResidentController.php:217
* @route '/api/resident/tickets/{ticket}'
*/
showTicketForm.head = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: showTicket.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

showTicket.form = showTicketForm

/**
* @see \App\Http\Controllers\Api\ResidentController::visitors
* @see app/Http/Controllers/Api/ResidentController.php:272
* @route '/api/resident/visitors'
*/
export const visitors = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: visitors.url(options),
    method: 'get',
})

visitors.definition = {
    methods: ["get","head"],
    url: '/api/resident/visitors',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\ResidentController::visitors
* @see app/Http/Controllers/Api/ResidentController.php:272
* @route '/api/resident/visitors'
*/
visitors.url = (options?: RouteQueryOptions) => {
    return visitors.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\ResidentController::visitors
* @see app/Http/Controllers/Api/ResidentController.php:272
* @route '/api/resident/visitors'
*/
visitors.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: visitors.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::visitors
* @see app/Http/Controllers/Api/ResidentController.php:272
* @route '/api/resident/visitors'
*/
visitors.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: visitors.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::visitors
* @see app/Http/Controllers/Api/ResidentController.php:272
* @route '/api/resident/visitors'
*/
const visitorsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: visitors.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::visitors
* @see app/Http/Controllers/Api/ResidentController.php:272
* @route '/api/resident/visitors'
*/
visitorsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: visitors.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::visitors
* @see app/Http/Controllers/Api/ResidentController.php:272
* @route '/api/resident/visitors'
*/
visitorsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: visitors.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

visitors.form = visitorsForm

/**
* @see \App\Http\Controllers\Api\ResidentController::preApproveVisitor
* @see app/Http/Controllers/Api/ResidentController.php:312
* @route '/api/resident/visitors/pre-approve'
*/
export const preApproveVisitor = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: preApproveVisitor.url(options),
    method: 'post',
})

preApproveVisitor.definition = {
    methods: ["post"],
    url: '/api/resident/visitors/pre-approve',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\ResidentController::preApproveVisitor
* @see app/Http/Controllers/Api/ResidentController.php:312
* @route '/api/resident/visitors/pre-approve'
*/
preApproveVisitor.url = (options?: RouteQueryOptions) => {
    return preApproveVisitor.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\ResidentController::preApproveVisitor
* @see app/Http/Controllers/Api/ResidentController.php:312
* @route '/api/resident/visitors/pre-approve'
*/
preApproveVisitor.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: preApproveVisitor.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::preApproveVisitor
* @see app/Http/Controllers/Api/ResidentController.php:312
* @route '/api/resident/visitors/pre-approve'
*/
const preApproveVisitorForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: preApproveVisitor.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::preApproveVisitor
* @see app/Http/Controllers/Api/ResidentController.php:312
* @route '/api/resident/visitors/pre-approve'
*/
preApproveVisitorForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: preApproveVisitor.url(options),
    method: 'post',
})

preApproveVisitor.form = preApproveVisitorForm

/**
* @see \App\Http\Controllers\Api\ResidentController::approveVisitor
* @see app/Http/Controllers/Api/ResidentController.php:363
* @route '/api/resident/visitors/{visitor}/approve'
*/
export const approveVisitor = (args: { visitor: number | { id: number } } | [visitor: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: approveVisitor.url(args, options),
    method: 'post',
})

approveVisitor.definition = {
    methods: ["post"],
    url: '/api/resident/visitors/{visitor}/approve',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\ResidentController::approveVisitor
* @see app/Http/Controllers/Api/ResidentController.php:363
* @route '/api/resident/visitors/{visitor}/approve'
*/
approveVisitor.url = (args: { visitor: number | { id: number } } | [visitor: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { visitor: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { visitor: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            visitor: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        visitor: typeof args.visitor === 'object'
        ? args.visitor.id
        : args.visitor,
    }

    return approveVisitor.definition.url
            .replace('{visitor}', parsedArgs.visitor.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\ResidentController::approveVisitor
* @see app/Http/Controllers/Api/ResidentController.php:363
* @route '/api/resident/visitors/{visitor}/approve'
*/
approveVisitor.post = (args: { visitor: number | { id: number } } | [visitor: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: approveVisitor.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::approveVisitor
* @see app/Http/Controllers/Api/ResidentController.php:363
* @route '/api/resident/visitors/{visitor}/approve'
*/
const approveVisitorForm = (args: { visitor: number | { id: number } } | [visitor: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: approveVisitor.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::approveVisitor
* @see app/Http/Controllers/Api/ResidentController.php:363
* @route '/api/resident/visitors/{visitor}/approve'
*/
approveVisitorForm.post = (args: { visitor: number | { id: number } } | [visitor: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: approveVisitor.url(args, options),
    method: 'post',
})

approveVisitor.form = approveVisitorForm

/**
* @see \App\Http\Controllers\Api\ResidentController::rejectVisitor
* @see app/Http/Controllers/Api/ResidentController.php:427
* @route '/api/resident/visitors/{visitor}/reject'
*/
export const rejectVisitor = (args: { visitor: number | { id: number } } | [visitor: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: rejectVisitor.url(args, options),
    method: 'post',
})

rejectVisitor.definition = {
    methods: ["post"],
    url: '/api/resident/visitors/{visitor}/reject',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\ResidentController::rejectVisitor
* @see app/Http/Controllers/Api/ResidentController.php:427
* @route '/api/resident/visitors/{visitor}/reject'
*/
rejectVisitor.url = (args: { visitor: number | { id: number } } | [visitor: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { visitor: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { visitor: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            visitor: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        visitor: typeof args.visitor === 'object'
        ? args.visitor.id
        : args.visitor,
    }

    return rejectVisitor.definition.url
            .replace('{visitor}', parsedArgs.visitor.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\ResidentController::rejectVisitor
* @see app/Http/Controllers/Api/ResidentController.php:427
* @route '/api/resident/visitors/{visitor}/reject'
*/
rejectVisitor.post = (args: { visitor: number | { id: number } } | [visitor: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: rejectVisitor.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::rejectVisitor
* @see app/Http/Controllers/Api/ResidentController.php:427
* @route '/api/resident/visitors/{visitor}/reject'
*/
const rejectVisitorForm = (args: { visitor: number | { id: number } } | [visitor: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: rejectVisitor.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::rejectVisitor
* @see app/Http/Controllers/Api/ResidentController.php:427
* @route '/api/resident/visitors/{visitor}/reject'
*/
rejectVisitorForm.post = (args: { visitor: number | { id: number } } | [visitor: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: rejectVisitor.url(args, options),
    method: 'post',
})

rejectVisitor.form = rejectVisitorForm

/**
* @see \App\Http\Controllers\Api\ResidentController::payments
* @see app/Http/Controllers/Api/ResidentController.php:494
* @route '/api/resident/payments'
*/
export const payments = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: payments.url(options),
    method: 'get',
})

payments.definition = {
    methods: ["get","head"],
    url: '/api/resident/payments',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\ResidentController::payments
* @see app/Http/Controllers/Api/ResidentController.php:494
* @route '/api/resident/payments'
*/
payments.url = (options?: RouteQueryOptions) => {
    return payments.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\ResidentController::payments
* @see app/Http/Controllers/Api/ResidentController.php:494
* @route '/api/resident/payments'
*/
payments.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: payments.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::payments
* @see app/Http/Controllers/Api/ResidentController.php:494
* @route '/api/resident/payments'
*/
payments.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: payments.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::payments
* @see app/Http/Controllers/Api/ResidentController.php:494
* @route '/api/resident/payments'
*/
const paymentsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: payments.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::payments
* @see app/Http/Controllers/Api/ResidentController.php:494
* @route '/api/resident/payments'
*/
paymentsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: payments.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ResidentController::payments
* @see app/Http/Controllers/Api/ResidentController.php:494
* @route '/api/resident/payments'
*/
paymentsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: payments.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

payments.form = paymentsForm

const ResidentController = { bills, showBill, createOrder, verifyPayment, tickets, storeTicket, showTicket, visitors, preApproveVisitor, approveVisitor, rejectVisitor, payments }

export default ResidentController