import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\RentRecordController::ownerIndex
* @see app/Http/Controllers/Api/RentRecordController.php:42
* @route '/api/resident/rent-records'
*/
export const ownerIndex = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ownerIndex.url(options),
    method: 'get',
})

ownerIndex.definition = {
    methods: ["get","head"],
    url: '/api/resident/rent-records',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\RentRecordController::ownerIndex
* @see app/Http/Controllers/Api/RentRecordController.php:42
* @route '/api/resident/rent-records'
*/
ownerIndex.url = (options?: RouteQueryOptions) => {
    return ownerIndex.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\RentRecordController::ownerIndex
* @see app/Http/Controllers/Api/RentRecordController.php:42
* @route '/api/resident/rent-records'
*/
ownerIndex.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ownerIndex.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::ownerIndex
* @see app/Http/Controllers/Api/RentRecordController.php:42
* @route '/api/resident/rent-records'
*/
ownerIndex.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: ownerIndex.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::ownerIndex
* @see app/Http/Controllers/Api/RentRecordController.php:42
* @route '/api/resident/rent-records'
*/
const ownerIndexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ownerIndex.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::ownerIndex
* @see app/Http/Controllers/Api/RentRecordController.php:42
* @route '/api/resident/rent-records'
*/
ownerIndexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ownerIndex.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::ownerIndex
* @see app/Http/Controllers/Api/RentRecordController.php:42
* @route '/api/resident/rent-records'
*/
ownerIndexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ownerIndex.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

ownerIndex.form = ownerIndexForm

/**
* @see \App\Http\Controllers\Api\RentRecordController::recentTransactions
* @see app/Http/Controllers/Api/RentRecordController.php:353
* @route '/api/resident/rent-records/recent'
*/
const recentTransactions3bf0115a15da52bebb362d59ec8ed8a1 = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: recentTransactions3bf0115a15da52bebb362d59ec8ed8a1.url(options),
    method: 'get',
})

recentTransactions3bf0115a15da52bebb362d59ec8ed8a1.definition = {
    methods: ["get","head"],
    url: '/api/resident/rent-records/recent',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\RentRecordController::recentTransactions
* @see app/Http/Controllers/Api/RentRecordController.php:353
* @route '/api/resident/rent-records/recent'
*/
recentTransactions3bf0115a15da52bebb362d59ec8ed8a1.url = (options?: RouteQueryOptions) => {
    return recentTransactions3bf0115a15da52bebb362d59ec8ed8a1.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\RentRecordController::recentTransactions
* @see app/Http/Controllers/Api/RentRecordController.php:353
* @route '/api/resident/rent-records/recent'
*/
recentTransactions3bf0115a15da52bebb362d59ec8ed8a1.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: recentTransactions3bf0115a15da52bebb362d59ec8ed8a1.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::recentTransactions
* @see app/Http/Controllers/Api/RentRecordController.php:353
* @route '/api/resident/rent-records/recent'
*/
recentTransactions3bf0115a15da52bebb362d59ec8ed8a1.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: recentTransactions3bf0115a15da52bebb362d59ec8ed8a1.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::recentTransactions
* @see app/Http/Controllers/Api/RentRecordController.php:353
* @route '/api/resident/rent-records/recent'
*/
const recentTransactions3bf0115a15da52bebb362d59ec8ed8a1Form = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: recentTransactions3bf0115a15da52bebb362d59ec8ed8a1.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::recentTransactions
* @see app/Http/Controllers/Api/RentRecordController.php:353
* @route '/api/resident/rent-records/recent'
*/
recentTransactions3bf0115a15da52bebb362d59ec8ed8a1Form.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: recentTransactions3bf0115a15da52bebb362d59ec8ed8a1.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::recentTransactions
* @see app/Http/Controllers/Api/RentRecordController.php:353
* @route '/api/resident/rent-records/recent'
*/
recentTransactions3bf0115a15da52bebb362d59ec8ed8a1Form.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: recentTransactions3bf0115a15da52bebb362d59ec8ed8a1.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

recentTransactions3bf0115a15da52bebb362d59ec8ed8a1.form = recentTransactions3bf0115a15da52bebb362d59ec8ed8a1Form
/**
* @see \App\Http\Controllers\Api\RentRecordController::recentTransactions
* @see app/Http/Controllers/Api/RentRecordController.php:353
* @route '/api/tenant/rent-records/recent'
*/
const recentTransactions433014798f0dcc6fc40a752838c4e66d = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: recentTransactions433014798f0dcc6fc40a752838c4e66d.url(options),
    method: 'get',
})

recentTransactions433014798f0dcc6fc40a752838c4e66d.definition = {
    methods: ["get","head"],
    url: '/api/tenant/rent-records/recent',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\RentRecordController::recentTransactions
* @see app/Http/Controllers/Api/RentRecordController.php:353
* @route '/api/tenant/rent-records/recent'
*/
recentTransactions433014798f0dcc6fc40a752838c4e66d.url = (options?: RouteQueryOptions) => {
    return recentTransactions433014798f0dcc6fc40a752838c4e66d.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\RentRecordController::recentTransactions
* @see app/Http/Controllers/Api/RentRecordController.php:353
* @route '/api/tenant/rent-records/recent'
*/
recentTransactions433014798f0dcc6fc40a752838c4e66d.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: recentTransactions433014798f0dcc6fc40a752838c4e66d.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::recentTransactions
* @see app/Http/Controllers/Api/RentRecordController.php:353
* @route '/api/tenant/rent-records/recent'
*/
recentTransactions433014798f0dcc6fc40a752838c4e66d.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: recentTransactions433014798f0dcc6fc40a752838c4e66d.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::recentTransactions
* @see app/Http/Controllers/Api/RentRecordController.php:353
* @route '/api/tenant/rent-records/recent'
*/
const recentTransactions433014798f0dcc6fc40a752838c4e66dForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: recentTransactions433014798f0dcc6fc40a752838c4e66d.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::recentTransactions
* @see app/Http/Controllers/Api/RentRecordController.php:353
* @route '/api/tenant/rent-records/recent'
*/
recentTransactions433014798f0dcc6fc40a752838c4e66dForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: recentTransactions433014798f0dcc6fc40a752838c4e66d.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::recentTransactions
* @see app/Http/Controllers/Api/RentRecordController.php:353
* @route '/api/tenant/rent-records/recent'
*/
recentTransactions433014798f0dcc6fc40a752838c4e66dForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: recentTransactions433014798f0dcc6fc40a752838c4e66d.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

recentTransactions433014798f0dcc6fc40a752838c4e66d.form = recentTransactions433014798f0dcc6fc40a752838c4e66dForm

export const recentTransactions = {
    '/api/resident/rent-records/recent': recentTransactions3bf0115a15da52bebb362d59ec8ed8a1,
    '/api/tenant/rent-records/recent': recentTransactions433014798f0dcc6fc40a752838c4e66d,
}

/**
* @see \App\Http\Controllers\Api\RentRecordController::tenantRecords
* @see app/Http/Controllers/Api/RentRecordController.php:62
* @route '/api/resident/tenants/{tenantId}/rent-records'
*/
export const tenantRecords = (args: { tenantId: string | number } | [tenantId: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: tenantRecords.url(args, options),
    method: 'get',
})

tenantRecords.definition = {
    methods: ["get","head"],
    url: '/api/resident/tenants/{tenantId}/rent-records',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\RentRecordController::tenantRecords
* @see app/Http/Controllers/Api/RentRecordController.php:62
* @route '/api/resident/tenants/{tenantId}/rent-records'
*/
tenantRecords.url = (args: { tenantId: string | number } | [tenantId: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { tenantId: args }
    }

    if (Array.isArray(args)) {
        args = {
            tenantId: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        tenantId: args.tenantId,
    }

    return tenantRecords.definition.url
            .replace('{tenantId}', parsedArgs.tenantId.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\RentRecordController::tenantRecords
* @see app/Http/Controllers/Api/RentRecordController.php:62
* @route '/api/resident/tenants/{tenantId}/rent-records'
*/
tenantRecords.get = (args: { tenantId: string | number } | [tenantId: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: tenantRecords.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::tenantRecords
* @see app/Http/Controllers/Api/RentRecordController.php:62
* @route '/api/resident/tenants/{tenantId}/rent-records'
*/
tenantRecords.head = (args: { tenantId: string | number } | [tenantId: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: tenantRecords.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::tenantRecords
* @see app/Http/Controllers/Api/RentRecordController.php:62
* @route '/api/resident/tenants/{tenantId}/rent-records'
*/
const tenantRecordsForm = (args: { tenantId: string | number } | [tenantId: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: tenantRecords.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::tenantRecords
* @see app/Http/Controllers/Api/RentRecordController.php:62
* @route '/api/resident/tenants/{tenantId}/rent-records'
*/
tenantRecordsForm.get = (args: { tenantId: string | number } | [tenantId: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: tenantRecords.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::tenantRecords
* @see app/Http/Controllers/Api/RentRecordController.php:62
* @route '/api/resident/tenants/{tenantId}/rent-records'
*/
tenantRecordsForm.head = (args: { tenantId: string | number } | [tenantId: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: tenantRecords.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

tenantRecords.form = tenantRecordsForm

/**
* @see \App\Http\Controllers\Api\RentRecordController::store
* @see app/Http/Controllers/Api/RentRecordController.php:86
* @route '/api/resident/rent-records'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/api/resident/rent-records',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\RentRecordController::store
* @see app/Http/Controllers/Api/RentRecordController.php:86
* @route '/api/resident/rent-records'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\RentRecordController::store
* @see app/Http/Controllers/Api/RentRecordController.php:86
* @route '/api/resident/rent-records'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::store
* @see app/Http/Controllers/Api/RentRecordController.php:86
* @route '/api/resident/rent-records'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::store
* @see app/Http/Controllers/Api/RentRecordController.php:86
* @route '/api/resident/rent-records'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\Api\RentRecordController::update
* @see app/Http/Controllers/Api/RentRecordController.php:136
* @route '/api/resident/rent-records/{id}'
*/
export const update = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/api/resident/rent-records/{id}',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\Api\RentRecordController::update
* @see app/Http/Controllers/Api/RentRecordController.php:136
* @route '/api/resident/rent-records/{id}'
*/
update.url = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { id: args }
    }

    if (Array.isArray(args)) {
        args = {
            id: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        id: args.id,
    }

    return update.definition.url
            .replace('{id}', parsedArgs.id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\RentRecordController::update
* @see app/Http/Controllers/Api/RentRecordController.php:136
* @route '/api/resident/rent-records/{id}'
*/
update.put = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::update
* @see app/Http/Controllers/Api/RentRecordController.php:136
* @route '/api/resident/rent-records/{id}'
*/
const updateForm = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::update
* @see app/Http/Controllers/Api/RentRecordController.php:136
* @route '/api/resident/rent-records/{id}'
*/
updateForm.put = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\Api\RentRecordController::markPaid
* @see app/Http/Controllers/Api/RentRecordController.php:196
* @route '/api/resident/rent-records/{id}/mark-paid'
*/
export const markPaid = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: markPaid.url(args, options),
    method: 'post',
})

markPaid.definition = {
    methods: ["post"],
    url: '/api/resident/rent-records/{id}/mark-paid',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\RentRecordController::markPaid
* @see app/Http/Controllers/Api/RentRecordController.php:196
* @route '/api/resident/rent-records/{id}/mark-paid'
*/
markPaid.url = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { id: args }
    }

    if (Array.isArray(args)) {
        args = {
            id: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        id: args.id,
    }

    return markPaid.definition.url
            .replace('{id}', parsedArgs.id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\RentRecordController::markPaid
* @see app/Http/Controllers/Api/RentRecordController.php:196
* @route '/api/resident/rent-records/{id}/mark-paid'
*/
markPaid.post = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: markPaid.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::markPaid
* @see app/Http/Controllers/Api/RentRecordController.php:196
* @route '/api/resident/rent-records/{id}/mark-paid'
*/
const markPaidForm = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: markPaid.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::markPaid
* @see app/Http/Controllers/Api/RentRecordController.php:196
* @route '/api/resident/rent-records/{id}/mark-paid'
*/
markPaidForm.post = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: markPaid.url(args, options),
    method: 'post',
})

markPaid.form = markPaidForm

/**
* @see \App\Http\Controllers\Api\RentRecordController::approvePayment
* @see app/Http/Controllers/Api/RentRecordController.php:297
* @route '/api/resident/rent-records/{id}/approve-payment'
*/
export const approvePayment = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: approvePayment.url(args, options),
    method: 'post',
})

approvePayment.definition = {
    methods: ["post"],
    url: '/api/resident/rent-records/{id}/approve-payment',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\RentRecordController::approvePayment
* @see app/Http/Controllers/Api/RentRecordController.php:297
* @route '/api/resident/rent-records/{id}/approve-payment'
*/
approvePayment.url = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { id: args }
    }

    if (Array.isArray(args)) {
        args = {
            id: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        id: args.id,
    }

    return approvePayment.definition.url
            .replace('{id}', parsedArgs.id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\RentRecordController::approvePayment
* @see app/Http/Controllers/Api/RentRecordController.php:297
* @route '/api/resident/rent-records/{id}/approve-payment'
*/
approvePayment.post = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: approvePayment.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::approvePayment
* @see app/Http/Controllers/Api/RentRecordController.php:297
* @route '/api/resident/rent-records/{id}/approve-payment'
*/
const approvePaymentForm = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: approvePayment.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::approvePayment
* @see app/Http/Controllers/Api/RentRecordController.php:297
* @route '/api/resident/rent-records/{id}/approve-payment'
*/
approvePaymentForm.post = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: approvePayment.url(args, options),
    method: 'post',
})

approvePayment.form = approvePaymentForm

/**
* @see \App\Http\Controllers\Api\RentRecordController::tenantIndex
* @see app/Http/Controllers/Api/RentRecordController.php:16
* @route '/api/tenant/rent-records'
*/
export const tenantIndex = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: tenantIndex.url(options),
    method: 'get',
})

tenantIndex.definition = {
    methods: ["get","head"],
    url: '/api/tenant/rent-records',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\RentRecordController::tenantIndex
* @see app/Http/Controllers/Api/RentRecordController.php:16
* @route '/api/tenant/rent-records'
*/
tenantIndex.url = (options?: RouteQueryOptions) => {
    return tenantIndex.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\RentRecordController::tenantIndex
* @see app/Http/Controllers/Api/RentRecordController.php:16
* @route '/api/tenant/rent-records'
*/
tenantIndex.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: tenantIndex.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::tenantIndex
* @see app/Http/Controllers/Api/RentRecordController.php:16
* @route '/api/tenant/rent-records'
*/
tenantIndex.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: tenantIndex.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::tenantIndex
* @see app/Http/Controllers/Api/RentRecordController.php:16
* @route '/api/tenant/rent-records'
*/
const tenantIndexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: tenantIndex.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::tenantIndex
* @see app/Http/Controllers/Api/RentRecordController.php:16
* @route '/api/tenant/rent-records'
*/
tenantIndexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: tenantIndex.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\RentRecordController::tenantIndex
* @see app/Http/Controllers/Api/RentRecordController.php:16
* @route '/api/tenant/rent-records'
*/
tenantIndexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: tenantIndex.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

tenantIndex.form = tenantIndexForm

const RentRecordController = { ownerIndex, recentTransactions, tenantRecords, store, update, markPaid, approvePayment, tenantIndex }

export default RentRecordController