import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\ProfileController::show
* @see app/Http/Controllers/Api/ProfileController.php:16
* @route '/api/profile'
*/
export const show = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/api/profile',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\ProfileController::show
* @see app/Http/Controllers/Api/ProfileController.php:16
* @route '/api/profile'
*/
show.url = (options?: RouteQueryOptions) => {
    return show.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\ProfileController::show
* @see app/Http/Controllers/Api/ProfileController.php:16
* @route '/api/profile'
*/
show.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ProfileController::show
* @see app/Http/Controllers/Api/ProfileController.php:16
* @route '/api/profile'
*/
show.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\ProfileController::show
* @see app/Http/Controllers/Api/ProfileController.php:16
* @route '/api/profile'
*/
const showForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ProfileController::show
* @see app/Http/Controllers/Api/ProfileController.php:16
* @route '/api/profile'
*/
showForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\ProfileController::show
* @see app/Http/Controllers/Api/ProfileController.php:16
* @route '/api/profile'
*/
showForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\Api\ProfileController::update
* @see app/Http/Controllers/Api/ProfileController.php:29
* @route '/api/profile'
*/
export const update = (options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/api/profile',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\Api\ProfileController::update
* @see app/Http/Controllers/Api/ProfileController.php:29
* @route '/api/profile'
*/
update.url = (options?: RouteQueryOptions) => {
    return update.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\ProfileController::update
* @see app/Http/Controllers/Api/ProfileController.php:29
* @route '/api/profile'
*/
update.put = (options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\Api\ProfileController::update
* @see app/Http/Controllers/Api/ProfileController.php:29
* @route '/api/profile'
*/
const updateForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\ProfileController::update
* @see app/Http/Controllers/Api/ProfileController.php:29
* @route '/api/profile'
*/
updateForm.put = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\Api\ProfileController::changePassword
* @see app/Http/Controllers/Api/ProfileController.php:45
* @route '/api/change-password'
*/
export const changePassword = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: changePassword.url(options),
    method: 'post',
})

changePassword.definition = {
    methods: ["post"],
    url: '/api/change-password',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\ProfileController::changePassword
* @see app/Http/Controllers/Api/ProfileController.php:45
* @route '/api/change-password'
*/
changePassword.url = (options?: RouteQueryOptions) => {
    return changePassword.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\ProfileController::changePassword
* @see app/Http/Controllers/Api/ProfileController.php:45
* @route '/api/change-password'
*/
changePassword.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: changePassword.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\ProfileController::changePassword
* @see app/Http/Controllers/Api/ProfileController.php:45
* @route '/api/change-password'
*/
const changePasswordForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: changePassword.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\ProfileController::changePassword
* @see app/Http/Controllers/Api/ProfileController.php:45
* @route '/api/change-password'
*/
changePasswordForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: changePassword.url(options),
    method: 'post',
})

changePassword.form = changePasswordForm

const ProfileController = { show, update, changePassword }

export default ProfileController