import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\GuardController::visitors
* @see app/Http/Controllers/Api/GuardController.php:21
* @route '/api/guard/visitors'
*/
export const visitors = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: visitors.url(options),
    method: 'get',
})

visitors.definition = {
    methods: ["get","head"],
    url: '/api/guard/visitors',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\GuardController::visitors
* @see app/Http/Controllers/Api/GuardController.php:21
* @route '/api/guard/visitors'
*/
visitors.url = (options?: RouteQueryOptions) => {
    return visitors.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\GuardController::visitors
* @see app/Http/Controllers/Api/GuardController.php:21
* @route '/api/guard/visitors'
*/
visitors.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: visitors.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\GuardController::visitors
* @see app/Http/Controllers/Api/GuardController.php:21
* @route '/api/guard/visitors'
*/
visitors.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: visitors.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\GuardController::visitors
* @see app/Http/Controllers/Api/GuardController.php:21
* @route '/api/guard/visitors'
*/
const visitorsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: visitors.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\GuardController::visitors
* @see app/Http/Controllers/Api/GuardController.php:21
* @route '/api/guard/visitors'
*/
visitorsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: visitors.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\GuardController::visitors
* @see app/Http/Controllers/Api/GuardController.php:21
* @route '/api/guard/visitors'
*/
visitorsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: visitors.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

visitors.form = visitorsForm

/**
* @see \App\Http\Controllers\Api\GuardController::expectedVisitors
* @see app/Http/Controllers/Api/GuardController.php:43
* @route '/api/guard/visitors/expected'
*/
export const expectedVisitors = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: expectedVisitors.url(options),
    method: 'get',
})

expectedVisitors.definition = {
    methods: ["get","head"],
    url: '/api/guard/visitors/expected',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\GuardController::expectedVisitors
* @see app/Http/Controllers/Api/GuardController.php:43
* @route '/api/guard/visitors/expected'
*/
expectedVisitors.url = (options?: RouteQueryOptions) => {
    return expectedVisitors.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\GuardController::expectedVisitors
* @see app/Http/Controllers/Api/GuardController.php:43
* @route '/api/guard/visitors/expected'
*/
expectedVisitors.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: expectedVisitors.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\GuardController::expectedVisitors
* @see app/Http/Controllers/Api/GuardController.php:43
* @route '/api/guard/visitors/expected'
*/
expectedVisitors.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: expectedVisitors.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\GuardController::expectedVisitors
* @see app/Http/Controllers/Api/GuardController.php:43
* @route '/api/guard/visitors/expected'
*/
const expectedVisitorsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: expectedVisitors.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\GuardController::expectedVisitors
* @see app/Http/Controllers/Api/GuardController.php:43
* @route '/api/guard/visitors/expected'
*/
expectedVisitorsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: expectedVisitors.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\GuardController::expectedVisitors
* @see app/Http/Controllers/Api/GuardController.php:43
* @route '/api/guard/visitors/expected'
*/
expectedVisitorsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: expectedVisitors.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

expectedVisitors.form = expectedVisitorsForm

/**
* @see \App\Http\Controllers\Api\GuardController::verifiedVisitors
* @see app/Http/Controllers/Api/GuardController.php:63
* @route '/api/guard/visitors/verified'
*/
export const verifiedVisitors = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: verifiedVisitors.url(options),
    method: 'get',
})

verifiedVisitors.definition = {
    methods: ["get","head"],
    url: '/api/guard/visitors/verified',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\GuardController::verifiedVisitors
* @see app/Http/Controllers/Api/GuardController.php:63
* @route '/api/guard/visitors/verified'
*/
verifiedVisitors.url = (options?: RouteQueryOptions) => {
    return verifiedVisitors.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\GuardController::verifiedVisitors
* @see app/Http/Controllers/Api/GuardController.php:63
* @route '/api/guard/visitors/verified'
*/
verifiedVisitors.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: verifiedVisitors.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\GuardController::verifiedVisitors
* @see app/Http/Controllers/Api/GuardController.php:63
* @route '/api/guard/visitors/verified'
*/
verifiedVisitors.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: verifiedVisitors.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\GuardController::verifiedVisitors
* @see app/Http/Controllers/Api/GuardController.php:63
* @route '/api/guard/visitors/verified'
*/
const verifiedVisitorsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: verifiedVisitors.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\GuardController::verifiedVisitors
* @see app/Http/Controllers/Api/GuardController.php:63
* @route '/api/guard/visitors/verified'
*/
verifiedVisitorsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: verifiedVisitors.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\GuardController::verifiedVisitors
* @see app/Http/Controllers/Api/GuardController.php:63
* @route '/api/guard/visitors/verified'
*/
verifiedVisitorsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: verifiedVisitors.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

verifiedVisitors.form = verifiedVisitorsForm

/**
* @see \App\Http\Controllers\Api\GuardController::verifyVisitorOtp
* @see app/Http/Controllers/Api/GuardController.php:81
* @route '/api/guard/visitors/verify-otp'
*/
export const verifyVisitorOtp = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: verifyVisitorOtp.url(options),
    method: 'post',
})

verifyVisitorOtp.definition = {
    methods: ["post"],
    url: '/api/guard/visitors/verify-otp',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\GuardController::verifyVisitorOtp
* @see app/Http/Controllers/Api/GuardController.php:81
* @route '/api/guard/visitors/verify-otp'
*/
verifyVisitorOtp.url = (options?: RouteQueryOptions) => {
    return verifyVisitorOtp.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\GuardController::verifyVisitorOtp
* @see app/Http/Controllers/Api/GuardController.php:81
* @route '/api/guard/visitors/verify-otp'
*/
verifyVisitorOtp.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: verifyVisitorOtp.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\GuardController::verifyVisitorOtp
* @see app/Http/Controllers/Api/GuardController.php:81
* @route '/api/guard/visitors/verify-otp'
*/
const verifyVisitorOtpForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: verifyVisitorOtp.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\GuardController::verifyVisitorOtp
* @see app/Http/Controllers/Api/GuardController.php:81
* @route '/api/guard/visitors/verify-otp'
*/
verifyVisitorOtpForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: verifyVisitorOtp.url(options),
    method: 'post',
})

verifyVisitorOtp.form = verifyVisitorOtpForm

/**
* @see \App\Http\Controllers\Api\GuardController::checkIn
* @see app/Http/Controllers/Api/GuardController.php:129
* @route '/api/guard/visitors/check-in'
*/
export const checkIn = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: checkIn.url(options),
    method: 'post',
})

checkIn.definition = {
    methods: ["post"],
    url: '/api/guard/visitors/check-in',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\GuardController::checkIn
* @see app/Http/Controllers/Api/GuardController.php:129
* @route '/api/guard/visitors/check-in'
*/
checkIn.url = (options?: RouteQueryOptions) => {
    return checkIn.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\GuardController::checkIn
* @see app/Http/Controllers/Api/GuardController.php:129
* @route '/api/guard/visitors/check-in'
*/
checkIn.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: checkIn.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\GuardController::checkIn
* @see app/Http/Controllers/Api/GuardController.php:129
* @route '/api/guard/visitors/check-in'
*/
const checkInForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: checkIn.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\GuardController::checkIn
* @see app/Http/Controllers/Api/GuardController.php:129
* @route '/api/guard/visitors/check-in'
*/
checkInForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: checkIn.url(options),
    method: 'post',
})

checkIn.form = checkInForm

/**
* @see \App\Http\Controllers\Api\GuardController::checkOut
* @see app/Http/Controllers/Api/GuardController.php:217
* @route '/api/guard/visitors/{visitor}/check-out'
*/
export const checkOut = (args: { visitor: number | { id: number } } | [visitor: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: checkOut.url(args, options),
    method: 'post',
})

checkOut.definition = {
    methods: ["post"],
    url: '/api/guard/visitors/{visitor}/check-out',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\GuardController::checkOut
* @see app/Http/Controllers/Api/GuardController.php:217
* @route '/api/guard/visitors/{visitor}/check-out'
*/
checkOut.url = (args: { visitor: number | { id: number } } | [visitor: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { visitor: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { visitor: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            visitor: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        visitor: typeof args.visitor === 'object'
        ? args.visitor.id
        : args.visitor,
    }

    return checkOut.definition.url
            .replace('{visitor}', parsedArgs.visitor.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\GuardController::checkOut
* @see app/Http/Controllers/Api/GuardController.php:217
* @route '/api/guard/visitors/{visitor}/check-out'
*/
checkOut.post = (args: { visitor: number | { id: number } } | [visitor: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: checkOut.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\GuardController::checkOut
* @see app/Http/Controllers/Api/GuardController.php:217
* @route '/api/guard/visitors/{visitor}/check-out'
*/
const checkOutForm = (args: { visitor: number | { id: number } } | [visitor: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: checkOut.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\GuardController::checkOut
* @see app/Http/Controllers/Api/GuardController.php:217
* @route '/api/guard/visitors/{visitor}/check-out'
*/
checkOutForm.post = (args: { visitor: number | { id: number } } | [visitor: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: checkOut.url(args, options),
    method: 'post',
})

checkOut.form = checkOutForm

const GuardController = { visitors, expectedVisitors, verifiedVisitors, verifyVisitorOtp, checkIn, checkOut }

export default GuardController