import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\FcmTokenController::updateToken
* @see app/Http/Controllers/Api/FcmTokenController.php:14
* @route '/api/fcm-token'
*/
export const updateToken = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: updateToken.url(options),
    method: 'post',
})

updateToken.definition = {
    methods: ["post"],
    url: '/api/fcm-token',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\FcmTokenController::updateToken
* @see app/Http/Controllers/Api/FcmTokenController.php:14
* @route '/api/fcm-token'
*/
updateToken.url = (options?: RouteQueryOptions) => {
    return updateToken.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\FcmTokenController::updateToken
* @see app/Http/Controllers/Api/FcmTokenController.php:14
* @route '/api/fcm-token'
*/
updateToken.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: updateToken.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\FcmTokenController::updateToken
* @see app/Http/Controllers/Api/FcmTokenController.php:14
* @route '/api/fcm-token'
*/
const updateTokenForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateToken.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\FcmTokenController::updateToken
* @see app/Http/Controllers/Api/FcmTokenController.php:14
* @route '/api/fcm-token'
*/
updateTokenForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: updateToken.url(options),
    method: 'post',
})

updateToken.form = updateTokenForm

const FcmTokenController = { updateToken }

export default FcmTokenController