import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\FacilityController::index
* @see app/Http/Controllers/Api/FacilityController.php:18
* @route '/api/resident/facilities'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/api/resident/facilities',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\FacilityController::index
* @see app/Http/Controllers/Api/FacilityController.php:18
* @route '/api/resident/facilities'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\FacilityController::index
* @see app/Http/Controllers/Api/FacilityController.php:18
* @route '/api/resident/facilities'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\FacilityController::index
* @see app/Http/Controllers/Api/FacilityController.php:18
* @route '/api/resident/facilities'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\FacilityController::index
* @see app/Http/Controllers/Api/FacilityController.php:18
* @route '/api/resident/facilities'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\FacilityController::index
* @see app/Http/Controllers/Api/FacilityController.php:18
* @route '/api/resident/facilities'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\FacilityController::index
* @see app/Http/Controllers/Api/FacilityController.php:18
* @route '/api/resident/facilities'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\Api\FacilityController::show
* @see app/Http/Controllers/Api/FacilityController.php:87
* @route '/api/resident/facilities/{id}'
*/
export const show = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/api/resident/facilities/{id}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\FacilityController::show
* @see app/Http/Controllers/Api/FacilityController.php:87
* @route '/api/resident/facilities/{id}'
*/
show.url = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { id: args }
    }

    if (Array.isArray(args)) {
        args = {
            id: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        id: args.id,
    }

    return show.definition.url
            .replace('{id}', parsedArgs.id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\FacilityController::show
* @see app/Http/Controllers/Api/FacilityController.php:87
* @route '/api/resident/facilities/{id}'
*/
show.get = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\FacilityController::show
* @see app/Http/Controllers/Api/FacilityController.php:87
* @route '/api/resident/facilities/{id}'
*/
show.head = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\FacilityController::show
* @see app/Http/Controllers/Api/FacilityController.php:87
* @route '/api/resident/facilities/{id}'
*/
const showForm = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\FacilityController::show
* @see app/Http/Controllers/Api/FacilityController.php:87
* @route '/api/resident/facilities/{id}'
*/
showForm.get = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\FacilityController::show
* @see app/Http/Controllers/Api/FacilityController.php:87
* @route '/api/resident/facilities/{id}'
*/
showForm.head = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\Api\FacilityController::getSlots
* @see app/Http/Controllers/Api/FacilityController.php:193
* @route '/api/resident/facilities/{id}/slots'
*/
export const getSlots = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getSlots.url(args, options),
    method: 'get',
})

getSlots.definition = {
    methods: ["get","head"],
    url: '/api/resident/facilities/{id}/slots',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\FacilityController::getSlots
* @see app/Http/Controllers/Api/FacilityController.php:193
* @route '/api/resident/facilities/{id}/slots'
*/
getSlots.url = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { id: args }
    }

    if (Array.isArray(args)) {
        args = {
            id: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        id: args.id,
    }

    return getSlots.definition.url
            .replace('{id}', parsedArgs.id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\FacilityController::getSlots
* @see app/Http/Controllers/Api/FacilityController.php:193
* @route '/api/resident/facilities/{id}/slots'
*/
getSlots.get = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getSlots.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\FacilityController::getSlots
* @see app/Http/Controllers/Api/FacilityController.php:193
* @route '/api/resident/facilities/{id}/slots'
*/
getSlots.head = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: getSlots.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\FacilityController::getSlots
* @see app/Http/Controllers/Api/FacilityController.php:193
* @route '/api/resident/facilities/{id}/slots'
*/
const getSlotsForm = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getSlots.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\FacilityController::getSlots
* @see app/Http/Controllers/Api/FacilityController.php:193
* @route '/api/resident/facilities/{id}/slots'
*/
getSlotsForm.get = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getSlots.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\FacilityController::getSlots
* @see app/Http/Controllers/Api/FacilityController.php:193
* @route '/api/resident/facilities/{id}/slots'
*/
getSlotsForm.head = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getSlots.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

getSlots.form = getSlotsForm

/**
* @see \App\Http\Controllers\Api\FacilityController::checkAvailability
* @see app/Http/Controllers/Api/FacilityController.php:230
* @route '/api/resident/facilities/{id}/availability'
*/
export const checkAvailability = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: checkAvailability.url(args, options),
    method: 'get',
})

checkAvailability.definition = {
    methods: ["get","head"],
    url: '/api/resident/facilities/{id}/availability',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\FacilityController::checkAvailability
* @see app/Http/Controllers/Api/FacilityController.php:230
* @route '/api/resident/facilities/{id}/availability'
*/
checkAvailability.url = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { id: args }
    }

    if (Array.isArray(args)) {
        args = {
            id: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        id: args.id,
    }

    return checkAvailability.definition.url
            .replace('{id}', parsedArgs.id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\FacilityController::checkAvailability
* @see app/Http/Controllers/Api/FacilityController.php:230
* @route '/api/resident/facilities/{id}/availability'
*/
checkAvailability.get = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: checkAvailability.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\FacilityController::checkAvailability
* @see app/Http/Controllers/Api/FacilityController.php:230
* @route '/api/resident/facilities/{id}/availability'
*/
checkAvailability.head = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: checkAvailability.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\FacilityController::checkAvailability
* @see app/Http/Controllers/Api/FacilityController.php:230
* @route '/api/resident/facilities/{id}/availability'
*/
const checkAvailabilityForm = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: checkAvailability.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\FacilityController::checkAvailability
* @see app/Http/Controllers/Api/FacilityController.php:230
* @route '/api/resident/facilities/{id}/availability'
*/
checkAvailabilityForm.get = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: checkAvailability.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\FacilityController::checkAvailability
* @see app/Http/Controllers/Api/FacilityController.php:230
* @route '/api/resident/facilities/{id}/availability'
*/
checkAvailabilityForm.head = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: checkAvailability.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

checkAvailability.form = checkAvailabilityForm

const FacilityController = { index, show, getSlots, checkAvailability }

export default FacilityController