import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\EmergencyController::trigger
* @see app/Http/Controllers/Api/EmergencyController.php:17
* @route '/api/emergency/trigger'
*/
export const trigger = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: trigger.url(options),
    method: 'post',
})

trigger.definition = {
    methods: ["post"],
    url: '/api/emergency/trigger',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\EmergencyController::trigger
* @see app/Http/Controllers/Api/EmergencyController.php:17
* @route '/api/emergency/trigger'
*/
trigger.url = (options?: RouteQueryOptions) => {
    return trigger.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\EmergencyController::trigger
* @see app/Http/Controllers/Api/EmergencyController.php:17
* @route '/api/emergency/trigger'
*/
trigger.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: trigger.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::trigger
* @see app/Http/Controllers/Api/EmergencyController.php:17
* @route '/api/emergency/trigger'
*/
const triggerForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: trigger.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::trigger
* @see app/Http/Controllers/Api/EmergencyController.php:17
* @route '/api/emergency/trigger'
*/
triggerForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: trigger.url(options),
    method: 'post',
})

trigger.form = triggerForm

/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/api/emergency/active'
*/
const active70d682baa39e74e287eca85353a24dfb = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: active70d682baa39e74e287eca85353a24dfb.url(options),
    method: 'get',
})

active70d682baa39e74e287eca85353a24dfb.definition = {
    methods: ["get","head"],
    url: '/api/emergency/active',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/api/emergency/active'
*/
active70d682baa39e74e287eca85353a24dfb.url = (options?: RouteQueryOptions) => {
    return active70d682baa39e74e287eca85353a24dfb.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/api/emergency/active'
*/
active70d682baa39e74e287eca85353a24dfb.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: active70d682baa39e74e287eca85353a24dfb.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/api/emergency/active'
*/
active70d682baa39e74e287eca85353a24dfb.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: active70d682baa39e74e287eca85353a24dfb.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/api/emergency/active'
*/
const active70d682baa39e74e287eca85353a24dfbForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: active70d682baa39e74e287eca85353a24dfb.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/api/emergency/active'
*/
active70d682baa39e74e287eca85353a24dfbForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: active70d682baa39e74e287eca85353a24dfb.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/api/emergency/active'
*/
active70d682baa39e74e287eca85353a24dfbForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: active70d682baa39e74e287eca85353a24dfb.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

active70d682baa39e74e287eca85353a24dfb.form = active70d682baa39e74e287eca85353a24dfbForm
/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/societies/{society}/emergency/active'
*/
const active67036f4659f54354a7a4455e3924b1c9 = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: active67036f4659f54354a7a4455e3924b1c9.url(args, options),
    method: 'get',
})

active67036f4659f54354a7a4455e3924b1c9.definition = {
    methods: ["get","head"],
    url: '/societies/{society}/emergency/active',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/societies/{society}/emergency/active'
*/
active67036f4659f54354a7a4455e3924b1c9.url = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { society: args }
    }

    if (Array.isArray(args)) {
        args = {
            society: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: args.society,
    }

    return active67036f4659f54354a7a4455e3924b1c9.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/societies/{society}/emergency/active'
*/
active67036f4659f54354a7a4455e3924b1c9.get = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: active67036f4659f54354a7a4455e3924b1c9.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/societies/{society}/emergency/active'
*/
active67036f4659f54354a7a4455e3924b1c9.head = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: active67036f4659f54354a7a4455e3924b1c9.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/societies/{society}/emergency/active'
*/
const active67036f4659f54354a7a4455e3924b1c9Form = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: active67036f4659f54354a7a4455e3924b1c9.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/societies/{society}/emergency/active'
*/
active67036f4659f54354a7a4455e3924b1c9Form.get = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: active67036f4659f54354a7a4455e3924b1c9.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::active
* @see app/Http/Controllers/Api/EmergencyController.php:122
* @route '/societies/{society}/emergency/active'
*/
active67036f4659f54354a7a4455e3924b1c9Form.head = (args: { society: string | number } | [society: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: active67036f4659f54354a7a4455e3924b1c9.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

active67036f4659f54354a7a4455e3924b1c9.form = active67036f4659f54354a7a4455e3924b1c9Form

export const active = {
    '/api/emergency/active': active70d682baa39e74e287eca85353a24dfb,
    '/societies/{society}/emergency/active': active67036f4659f54354a7a4455e3924b1c9,
}

/**
* @see \App\Http\Controllers\Api\EmergencyController::resolve
* @see app/Http/Controllers/Api/EmergencyController.php:174
* @route '/api/emergency/{alert}/resolve'
*/
const resolvea77b98a5725a60aa37e23a43bf222ec2 = (args: { alert: string | number } | [alert: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: resolvea77b98a5725a60aa37e23a43bf222ec2.url(args, options),
    method: 'post',
})

resolvea77b98a5725a60aa37e23a43bf222ec2.definition = {
    methods: ["post"],
    url: '/api/emergency/{alert}/resolve',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\EmergencyController::resolve
* @see app/Http/Controllers/Api/EmergencyController.php:174
* @route '/api/emergency/{alert}/resolve'
*/
resolvea77b98a5725a60aa37e23a43bf222ec2.url = (args: { alert: string | number } | [alert: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { alert: args }
    }

    if (Array.isArray(args)) {
        args = {
            alert: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        alert: args.alert,
    }

    return resolvea77b98a5725a60aa37e23a43bf222ec2.definition.url
            .replace('{alert}', parsedArgs.alert.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\EmergencyController::resolve
* @see app/Http/Controllers/Api/EmergencyController.php:174
* @route '/api/emergency/{alert}/resolve'
*/
resolvea77b98a5725a60aa37e23a43bf222ec2.post = (args: { alert: string | number } | [alert: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: resolvea77b98a5725a60aa37e23a43bf222ec2.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::resolve
* @see app/Http/Controllers/Api/EmergencyController.php:174
* @route '/api/emergency/{alert}/resolve'
*/
const resolvea77b98a5725a60aa37e23a43bf222ec2Form = (args: { alert: string | number } | [alert: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: resolvea77b98a5725a60aa37e23a43bf222ec2.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::resolve
* @see app/Http/Controllers/Api/EmergencyController.php:174
* @route '/api/emergency/{alert}/resolve'
*/
resolvea77b98a5725a60aa37e23a43bf222ec2Form.post = (args: { alert: string | number } | [alert: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: resolvea77b98a5725a60aa37e23a43bf222ec2.url(args, options),
    method: 'post',
})

resolvea77b98a5725a60aa37e23a43bf222ec2.form = resolvea77b98a5725a60aa37e23a43bf222ec2Form
/**
* @see \App\Http\Controllers\Api\EmergencyController::resolve
* @see app/Http/Controllers/Api/EmergencyController.php:174
* @route '/societies/{society}/emergency/{id}/resolve'
*/
const resolve87f39778f95c163cbc6277a0e9caaecb = (args: { society: string | number, id: string | number } | [society: string | number, id: string | number ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: resolve87f39778f95c163cbc6277a0e9caaecb.url(args, options),
    method: 'post',
})

resolve87f39778f95c163cbc6277a0e9caaecb.definition = {
    methods: ["post"],
    url: '/societies/{society}/emergency/{id}/resolve',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\EmergencyController::resolve
* @see app/Http/Controllers/Api/EmergencyController.php:174
* @route '/societies/{society}/emergency/{id}/resolve'
*/
resolve87f39778f95c163cbc6277a0e9caaecb.url = (args: { society: string | number, id: string | number } | [society: string | number, id: string | number ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            society: args[0],
            id: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        society: args.society,
        id: args.id,
    }

    return resolve87f39778f95c163cbc6277a0e9caaecb.definition.url
            .replace('{society}', parsedArgs.society.toString())
            .replace('{id}', parsedArgs.id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\EmergencyController::resolve
* @see app/Http/Controllers/Api/EmergencyController.php:174
* @route '/societies/{society}/emergency/{id}/resolve'
*/
resolve87f39778f95c163cbc6277a0e9caaecb.post = (args: { society: string | number, id: string | number } | [society: string | number, id: string | number ], options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: resolve87f39778f95c163cbc6277a0e9caaecb.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::resolve
* @see app/Http/Controllers/Api/EmergencyController.php:174
* @route '/societies/{society}/emergency/{id}/resolve'
*/
const resolve87f39778f95c163cbc6277a0e9caaecbForm = (args: { society: string | number, id: string | number } | [society: string | number, id: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: resolve87f39778f95c163cbc6277a0e9caaecb.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\EmergencyController::resolve
* @see app/Http/Controllers/Api/EmergencyController.php:174
* @route '/societies/{society}/emergency/{id}/resolve'
*/
resolve87f39778f95c163cbc6277a0e9caaecbForm.post = (args: { society: string | number, id: string | number } | [society: string | number, id: string | number ], options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: resolve87f39778f95c163cbc6277a0e9caaecb.url(args, options),
    method: 'post',
})

resolve87f39778f95c163cbc6277a0e9caaecb.form = resolve87f39778f95c163cbc6277a0e9caaecbForm

export const resolve = {
    '/api/emergency/{alert}/resolve': resolvea77b98a5725a60aa37e23a43bf222ec2,
    '/societies/{society}/emergency/{id}/resolve': resolve87f39778f95c163cbc6277a0e9caaecb,
}

const EmergencyController = { trigger, active, resolve }

export default EmergencyController