import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\CommunityController::index
* @see app/Http/Controllers/Api/CommunityController.php:20
* @route '/api/community/posts'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/api/community/posts',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\CommunityController::index
* @see app/Http/Controllers/Api/CommunityController.php:20
* @route '/api/community/posts'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CommunityController::index
* @see app/Http/Controllers/Api/CommunityController.php:20
* @route '/api/community/posts'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CommunityController::index
* @see app/Http/Controllers/Api/CommunityController.php:20
* @route '/api/community/posts'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\CommunityController::index
* @see app/Http/Controllers/Api/CommunityController.php:20
* @route '/api/community/posts'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CommunityController::index
* @see app/Http/Controllers/Api/CommunityController.php:20
* @route '/api/community/posts'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CommunityController::index
* @see app/Http/Controllers/Api/CommunityController.php:20
* @route '/api/community/posts'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\Api\CommunityController::store
* @see app/Http/Controllers/Api/CommunityController.php:42
* @route '/api/community/posts'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/api/community/posts',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\CommunityController::store
* @see app/Http/Controllers/Api/CommunityController.php:42
* @route '/api/community/posts'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CommunityController::store
* @see app/Http/Controllers/Api/CommunityController.php:42
* @route '/api/community/posts'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\CommunityController::store
* @see app/Http/Controllers/Api/CommunityController.php:42
* @route '/api/community/posts'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\CommunityController::store
* @see app/Http/Controllers/Api/CommunityController.php:42
* @route '/api/community/posts'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\Api\CommunityController::like
* @see app/Http/Controllers/Api/CommunityController.php:106
* @route '/api/community/posts/{id}/like'
*/
export const like = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: like.url(args, options),
    method: 'post',
})

like.definition = {
    methods: ["post"],
    url: '/api/community/posts/{id}/like',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\CommunityController::like
* @see app/Http/Controllers/Api/CommunityController.php:106
* @route '/api/community/posts/{id}/like'
*/
like.url = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { id: args }
    }

    if (Array.isArray(args)) {
        args = {
            id: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        id: args.id,
    }

    return like.definition.url
            .replace('{id}', parsedArgs.id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CommunityController::like
* @see app/Http/Controllers/Api/CommunityController.php:106
* @route '/api/community/posts/{id}/like'
*/
like.post = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: like.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\CommunityController::like
* @see app/Http/Controllers/Api/CommunityController.php:106
* @route '/api/community/posts/{id}/like'
*/
const likeForm = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: like.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\CommunityController::like
* @see app/Http/Controllers/Api/CommunityController.php:106
* @route '/api/community/posts/{id}/like'
*/
likeForm.post = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: like.url(args, options),
    method: 'post',
})

like.form = likeForm

/**
* @see \App\Http\Controllers\Api\CommunityController::comment
* @see app/Http/Controllers/Api/CommunityController.php:139
* @route '/api/community/posts/{id}/comments'
*/
export const comment = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: comment.url(args, options),
    method: 'post',
})

comment.definition = {
    methods: ["post"],
    url: '/api/community/posts/{id}/comments',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\CommunityController::comment
* @see app/Http/Controllers/Api/CommunityController.php:139
* @route '/api/community/posts/{id}/comments'
*/
comment.url = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { id: args }
    }

    if (Array.isArray(args)) {
        args = {
            id: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        id: args.id,
    }

    return comment.definition.url
            .replace('{id}', parsedArgs.id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CommunityController::comment
* @see app/Http/Controllers/Api/CommunityController.php:139
* @route '/api/community/posts/{id}/comments'
*/
comment.post = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: comment.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\CommunityController::comment
* @see app/Http/Controllers/Api/CommunityController.php:139
* @route '/api/community/posts/{id}/comments'
*/
const commentForm = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: comment.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\CommunityController::comment
* @see app/Http/Controllers/Api/CommunityController.php:139
* @route '/api/community/posts/{id}/comments'
*/
commentForm.post = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: comment.url(args, options),
    method: 'post',
})

comment.form = commentForm

/**
* @see \App\Http\Controllers\Api\CommunityController::directory
* @see app/Http/Controllers/Api/CommunityController.php:170
* @route '/api/community/directory'
*/
export const directory = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: directory.url(options),
    method: 'get',
})

directory.definition = {
    methods: ["get","head"],
    url: '/api/community/directory',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\CommunityController::directory
* @see app/Http/Controllers/Api/CommunityController.php:170
* @route '/api/community/directory'
*/
directory.url = (options?: RouteQueryOptions) => {
    return directory.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CommunityController::directory
* @see app/Http/Controllers/Api/CommunityController.php:170
* @route '/api/community/directory'
*/
directory.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: directory.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CommunityController::directory
* @see app/Http/Controllers/Api/CommunityController.php:170
* @route '/api/community/directory'
*/
directory.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: directory.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\CommunityController::directory
* @see app/Http/Controllers/Api/CommunityController.php:170
* @route '/api/community/directory'
*/
const directoryForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: directory.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CommunityController::directory
* @see app/Http/Controllers/Api/CommunityController.php:170
* @route '/api/community/directory'
*/
directoryForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: directory.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CommunityController::directory
* @see app/Http/Controllers/Api/CommunityController.php:170
* @route '/api/community/directory'
*/
directoryForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: directory.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

directory.form = directoryForm

const CommunityController = { index, store, like, comment, directory }

export default CommunityController