import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\CommentController::index
* @see app/Http/Controllers/Api/CommentController.php:21
* @route '/api/resident/tickets/{ticket}/comments'
*/
export const index = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/api/resident/tickets/{ticket}/comments',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\CommentController::index
* @see app/Http/Controllers/Api/CommentController.php:21
* @route '/api/resident/tickets/{ticket}/comments'
*/
index.url = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { ticket: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { ticket: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            ticket: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        ticket: typeof args.ticket === 'object'
        ? args.ticket.id
        : args.ticket,
    }

    return index.definition.url
            .replace('{ticket}', parsedArgs.ticket.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CommentController::index
* @see app/Http/Controllers/Api/CommentController.php:21
* @route '/api/resident/tickets/{ticket}/comments'
*/
index.get = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CommentController::index
* @see app/Http/Controllers/Api/CommentController.php:21
* @route '/api/resident/tickets/{ticket}/comments'
*/
index.head = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\CommentController::index
* @see app/Http/Controllers/Api/CommentController.php:21
* @route '/api/resident/tickets/{ticket}/comments'
*/
const indexForm = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CommentController::index
* @see app/Http/Controllers/Api/CommentController.php:21
* @route '/api/resident/tickets/{ticket}/comments'
*/
indexForm.get = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CommentController::index
* @see app/Http/Controllers/Api/CommentController.php:21
* @route '/api/resident/tickets/{ticket}/comments'
*/
indexForm.head = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\Api\CommentController::store
* @see app/Http/Controllers/Api/CommentController.php:59
* @route '/api/resident/tickets/{ticket}/comments'
*/
const storede677def6416d1b98d17ee4192ea338e = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: storede677def6416d1b98d17ee4192ea338e.url(args, options),
    method: 'post',
})

storede677def6416d1b98d17ee4192ea338e.definition = {
    methods: ["post"],
    url: '/api/resident/tickets/{ticket}/comments',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\CommentController::store
* @see app/Http/Controllers/Api/CommentController.php:59
* @route '/api/resident/tickets/{ticket}/comments'
*/
storede677def6416d1b98d17ee4192ea338e.url = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { ticket: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { ticket: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            ticket: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        ticket: typeof args.ticket === 'object'
        ? args.ticket.id
        : args.ticket,
    }

    return storede677def6416d1b98d17ee4192ea338e.definition.url
            .replace('{ticket}', parsedArgs.ticket.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CommentController::store
* @see app/Http/Controllers/Api/CommentController.php:59
* @route '/api/resident/tickets/{ticket}/comments'
*/
storede677def6416d1b98d17ee4192ea338e.post = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: storede677def6416d1b98d17ee4192ea338e.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\CommentController::store
* @see app/Http/Controllers/Api/CommentController.php:59
* @route '/api/resident/tickets/{ticket}/comments'
*/
const storede677def6416d1b98d17ee4192ea338eForm = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: storede677def6416d1b98d17ee4192ea338e.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\CommentController::store
* @see app/Http/Controllers/Api/CommentController.php:59
* @route '/api/resident/tickets/{ticket}/comments'
*/
storede677def6416d1b98d17ee4192ea338eForm.post = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: storede677def6416d1b98d17ee4192ea338e.url(args, options),
    method: 'post',
})

storede677def6416d1b98d17ee4192ea338e.form = storede677def6416d1b98d17ee4192ea338eForm
/**
* @see \App\Http\Controllers\Api\CommentController::store
* @see app/Http/Controllers/Api/CommentController.php:59
* @route '/api/society-admin/tickets/{ticket}/reply'
*/
const storeb68d83f40e08c1a610d1ea6f2944f6a5 = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: storeb68d83f40e08c1a610d1ea6f2944f6a5.url(args, options),
    method: 'post',
})

storeb68d83f40e08c1a610d1ea6f2944f6a5.definition = {
    methods: ["post"],
    url: '/api/society-admin/tickets/{ticket}/reply',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\CommentController::store
* @see app/Http/Controllers/Api/CommentController.php:59
* @route '/api/society-admin/tickets/{ticket}/reply'
*/
storeb68d83f40e08c1a610d1ea6f2944f6a5.url = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { ticket: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { ticket: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            ticket: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        ticket: typeof args.ticket === 'object'
        ? args.ticket.id
        : args.ticket,
    }

    return storeb68d83f40e08c1a610d1ea6f2944f6a5.definition.url
            .replace('{ticket}', parsedArgs.ticket.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CommentController::store
* @see app/Http/Controllers/Api/CommentController.php:59
* @route '/api/society-admin/tickets/{ticket}/reply'
*/
storeb68d83f40e08c1a610d1ea6f2944f6a5.post = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: storeb68d83f40e08c1a610d1ea6f2944f6a5.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\CommentController::store
* @see app/Http/Controllers/Api/CommentController.php:59
* @route '/api/society-admin/tickets/{ticket}/reply'
*/
const storeb68d83f40e08c1a610d1ea6f2944f6a5Form = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: storeb68d83f40e08c1a610d1ea6f2944f6a5.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\CommentController::store
* @see app/Http/Controllers/Api/CommentController.php:59
* @route '/api/society-admin/tickets/{ticket}/reply'
*/
storeb68d83f40e08c1a610d1ea6f2944f6a5Form.post = (args: { ticket: number | { id: number } } | [ticket: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: storeb68d83f40e08c1a610d1ea6f2944f6a5.url(args, options),
    method: 'post',
})

storeb68d83f40e08c1a610d1ea6f2944f6a5.form = storeb68d83f40e08c1a610d1ea6f2944f6a5Form

export const store = {
    '/api/resident/tickets/{ticket}/comments': storede677def6416d1b98d17ee4192ea338e,
    '/api/society-admin/tickets/{ticket}/reply': storeb68d83f40e08c1a610d1ea6f2944f6a5,
}

const CommentController = { index, store }

export default CommentController