import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::bills
* @see app/Http/Controllers/Api/CollectorPaymentController.php:20
* @route '/api/collector/bills'
*/
export const bills = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: bills.url(options),
    method: 'get',
})

bills.definition = {
    methods: ["get","head"],
    url: '/api/collector/bills',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::bills
* @see app/Http/Controllers/Api/CollectorPaymentController.php:20
* @route '/api/collector/bills'
*/
bills.url = (options?: RouteQueryOptions) => {
    return bills.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::bills
* @see app/Http/Controllers/Api/CollectorPaymentController.php:20
* @route '/api/collector/bills'
*/
bills.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: bills.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::bills
* @see app/Http/Controllers/Api/CollectorPaymentController.php:20
* @route '/api/collector/bills'
*/
bills.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: bills.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::bills
* @see app/Http/Controllers/Api/CollectorPaymentController.php:20
* @route '/api/collector/bills'
*/
const billsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: bills.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::bills
* @see app/Http/Controllers/Api/CollectorPaymentController.php:20
* @route '/api/collector/bills'
*/
billsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: bills.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::bills
* @see app/Http/Controllers/Api/CollectorPaymentController.php:20
* @route '/api/collector/bills'
*/
billsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: bills.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

bills.form = billsForm

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::collect
* @see app/Http/Controllers/Api/CollectorPaymentController.php:95
* @route '/api/collector/payment/collect'
*/
export const collect = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: collect.url(options),
    method: 'post',
})

collect.definition = {
    methods: ["post"],
    url: '/api/collector/payment/collect',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::collect
* @see app/Http/Controllers/Api/CollectorPaymentController.php:95
* @route '/api/collector/payment/collect'
*/
collect.url = (options?: RouteQueryOptions) => {
    return collect.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::collect
* @see app/Http/Controllers/Api/CollectorPaymentController.php:95
* @route '/api/collector/payment/collect'
*/
collect.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: collect.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::collect
* @see app/Http/Controllers/Api/CollectorPaymentController.php:95
* @route '/api/collector/payment/collect'
*/
const collectForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: collect.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::collect
* @see app/Http/Controllers/Api/CollectorPaymentController.php:95
* @route '/api/collector/payment/collect'
*/
collectForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: collect.url(options),
    method: 'post',
})

collect.form = collectForm

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::checkStatus
* @see app/Http/Controllers/Api/CollectorPaymentController.php:298
* @route '/api/collector/payment/status/{request_id}'
*/
export const checkStatus = (args: { request_id: string | number } | [request_id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: checkStatus.url(args, options),
    method: 'get',
})

checkStatus.definition = {
    methods: ["get","head"],
    url: '/api/collector/payment/status/{request_id}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::checkStatus
* @see app/Http/Controllers/Api/CollectorPaymentController.php:298
* @route '/api/collector/payment/status/{request_id}'
*/
checkStatus.url = (args: { request_id: string | number } | [request_id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { request_id: args }
    }

    if (Array.isArray(args)) {
        args = {
            request_id: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        request_id: args.request_id,
    }

    return checkStatus.definition.url
            .replace('{request_id}', parsedArgs.request_id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::checkStatus
* @see app/Http/Controllers/Api/CollectorPaymentController.php:298
* @route '/api/collector/payment/status/{request_id}'
*/
checkStatus.get = (args: { request_id: string | number } | [request_id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: checkStatus.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::checkStatus
* @see app/Http/Controllers/Api/CollectorPaymentController.php:298
* @route '/api/collector/payment/status/{request_id}'
*/
checkStatus.head = (args: { request_id: string | number } | [request_id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: checkStatus.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::checkStatus
* @see app/Http/Controllers/Api/CollectorPaymentController.php:298
* @route '/api/collector/payment/status/{request_id}'
*/
const checkStatusForm = (args: { request_id: string | number } | [request_id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: checkStatus.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::checkStatus
* @see app/Http/Controllers/Api/CollectorPaymentController.php:298
* @route '/api/collector/payment/status/{request_id}'
*/
checkStatusForm.get = (args: { request_id: string | number } | [request_id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: checkStatus.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::checkStatus
* @see app/Http/Controllers/Api/CollectorPaymentController.php:298
* @route '/api/collector/payment/status/{request_id}'
*/
checkStatusForm.head = (args: { request_id: string | number } | [request_id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: checkStatus.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

checkStatus.form = checkStatusForm

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::history
* @see app/Http/Controllers/Api/CollectorPaymentController.php:408
* @route '/api/collector/payment/history'
*/
export const history = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: history.url(options),
    method: 'get',
})

history.definition = {
    methods: ["get","head"],
    url: '/api/collector/payment/history',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::history
* @see app/Http/Controllers/Api/CollectorPaymentController.php:408
* @route '/api/collector/payment/history'
*/
history.url = (options?: RouteQueryOptions) => {
    return history.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::history
* @see app/Http/Controllers/Api/CollectorPaymentController.php:408
* @route '/api/collector/payment/history'
*/
history.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: history.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::history
* @see app/Http/Controllers/Api/CollectorPaymentController.php:408
* @route '/api/collector/payment/history'
*/
history.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: history.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::history
* @see app/Http/Controllers/Api/CollectorPaymentController.php:408
* @route '/api/collector/payment/history'
*/
const historyForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: history.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::history
* @see app/Http/Controllers/Api/CollectorPaymentController.php:408
* @route '/api/collector/payment/history'
*/
historyForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: history.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorPaymentController::history
* @see app/Http/Controllers/Api/CollectorPaymentController.php:408
* @route '/api/collector/payment/history'
*/
historyForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: history.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

history.form = historyForm

const CollectorPaymentController = { bills, collect, checkStatus, history }

export default CollectorPaymentController