import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\CollectorController::dashboard
* @see app/Http/Controllers/Api/CollectorController.php:21
* @route '/api/collector/dashboard'
*/
export const dashboard = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: dashboard.url(options),
    method: 'get',
})

dashboard.definition = {
    methods: ["get","head"],
    url: '/api/collector/dashboard',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\CollectorController::dashboard
* @see app/Http/Controllers/Api/CollectorController.php:21
* @route '/api/collector/dashboard'
*/
dashboard.url = (options?: RouteQueryOptions) => {
    return dashboard.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CollectorController::dashboard
* @see app/Http/Controllers/Api/CollectorController.php:21
* @route '/api/collector/dashboard'
*/
dashboard.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: dashboard.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::dashboard
* @see app/Http/Controllers/Api/CollectorController.php:21
* @route '/api/collector/dashboard'
*/
dashboard.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: dashboard.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::dashboard
* @see app/Http/Controllers/Api/CollectorController.php:21
* @route '/api/collector/dashboard'
*/
const dashboardForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: dashboard.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::dashboard
* @see app/Http/Controllers/Api/CollectorController.php:21
* @route '/api/collector/dashboard'
*/
dashboardForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: dashboard.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::dashboard
* @see app/Http/Controllers/Api/CollectorController.php:21
* @route '/api/collector/dashboard'
*/
dashboardForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: dashboard.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

dashboard.form = dashboardForm

/**
* @see \App\Http\Controllers\Api\CollectorController::dues
* @see app/Http/Controllers/Api/CollectorController.php:169
* @route '/api/collector/dues'
*/
export const dues = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: dues.url(options),
    method: 'get',
})

dues.definition = {
    methods: ["get","head"],
    url: '/api/collector/dues',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\CollectorController::dues
* @see app/Http/Controllers/Api/CollectorController.php:169
* @route '/api/collector/dues'
*/
dues.url = (options?: RouteQueryOptions) => {
    return dues.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CollectorController::dues
* @see app/Http/Controllers/Api/CollectorController.php:169
* @route '/api/collector/dues'
*/
dues.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: dues.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::dues
* @see app/Http/Controllers/Api/CollectorController.php:169
* @route '/api/collector/dues'
*/
dues.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: dues.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::dues
* @see app/Http/Controllers/Api/CollectorController.php:169
* @route '/api/collector/dues'
*/
const duesForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: dues.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::dues
* @see app/Http/Controllers/Api/CollectorController.php:169
* @route '/api/collector/dues'
*/
duesForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: dues.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::dues
* @see app/Http/Controllers/Api/CollectorController.php:169
* @route '/api/collector/dues'
*/
duesForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: dues.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

dues.form = duesForm

/**
* @see \App\Http\Controllers\Api\CollectorController::cleared
* @see app/Http/Controllers/Api/CollectorController.php:252
* @route '/api/collector/cleared'
*/
export const cleared = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: cleared.url(options),
    method: 'get',
})

cleared.definition = {
    methods: ["get","head"],
    url: '/api/collector/cleared',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\CollectorController::cleared
* @see app/Http/Controllers/Api/CollectorController.php:252
* @route '/api/collector/cleared'
*/
cleared.url = (options?: RouteQueryOptions) => {
    return cleared.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CollectorController::cleared
* @see app/Http/Controllers/Api/CollectorController.php:252
* @route '/api/collector/cleared'
*/
cleared.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: cleared.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::cleared
* @see app/Http/Controllers/Api/CollectorController.php:252
* @route '/api/collector/cleared'
*/
cleared.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: cleared.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::cleared
* @see app/Http/Controllers/Api/CollectorController.php:252
* @route '/api/collector/cleared'
*/
const clearedForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: cleared.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::cleared
* @see app/Http/Controllers/Api/CollectorController.php:252
* @route '/api/collector/cleared'
*/
clearedForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: cleared.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::cleared
* @see app/Http/Controllers/Api/CollectorController.php:252
* @route '/api/collector/cleared'
*/
clearedForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: cleared.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

cleared.form = clearedForm

/**
* @see \App\Http\Controllers\Api\CollectorController::storePayment
* @see app/Http/Controllers/Api/CollectorController.php:317
* @route '/api/collector/payments'
*/
export const storePayment = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: storePayment.url(options),
    method: 'post',
})

storePayment.definition = {
    methods: ["post"],
    url: '/api/collector/payments',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\CollectorController::storePayment
* @see app/Http/Controllers/Api/CollectorController.php:317
* @route '/api/collector/payments'
*/
storePayment.url = (options?: RouteQueryOptions) => {
    return storePayment.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CollectorController::storePayment
* @see app/Http/Controllers/Api/CollectorController.php:317
* @route '/api/collector/payments'
*/
storePayment.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: storePayment.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::storePayment
* @see app/Http/Controllers/Api/CollectorController.php:317
* @route '/api/collector/payments'
*/
const storePaymentForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: storePayment.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::storePayment
* @see app/Http/Controllers/Api/CollectorController.php:317
* @route '/api/collector/payments'
*/
storePaymentForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: storePayment.url(options),
    method: 'post',
})

storePayment.form = storePaymentForm

/**
* @see \App\Http\Controllers\Api\CollectorController::reports
* @see app/Http/Controllers/Api/CollectorController.php:524
* @route '/api/collector/reports'
*/
export const reports = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: reports.url(options),
    method: 'get',
})

reports.definition = {
    methods: ["get","head"],
    url: '/api/collector/reports',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\CollectorController::reports
* @see app/Http/Controllers/Api/CollectorController.php:524
* @route '/api/collector/reports'
*/
reports.url = (options?: RouteQueryOptions) => {
    return reports.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CollectorController::reports
* @see app/Http/Controllers/Api/CollectorController.php:524
* @route '/api/collector/reports'
*/
reports.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: reports.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::reports
* @see app/Http/Controllers/Api/CollectorController.php:524
* @route '/api/collector/reports'
*/
reports.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: reports.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::reports
* @see app/Http/Controllers/Api/CollectorController.php:524
* @route '/api/collector/reports'
*/
const reportsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: reports.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::reports
* @see app/Http/Controllers/Api/CollectorController.php:524
* @route '/api/collector/reports'
*/
reportsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: reports.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::reports
* @see app/Http/Controllers/Api/CollectorController.php:524
* @route '/api/collector/reports'
*/
reportsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: reports.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

reports.form = reportsForm

/**
* @see \App\Http\Controllers\Api\CollectorController::unitDetails
* @see app/Http/Controllers/Api/CollectorController.php:611
* @route '/api/collector/units/{unit_id}'
*/
export const unitDetails = (args: { unit_id: string | number } | [unit_id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: unitDetails.url(args, options),
    method: 'get',
})

unitDetails.definition = {
    methods: ["get","head"],
    url: '/api/collector/units/{unit_id}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\CollectorController::unitDetails
* @see app/Http/Controllers/Api/CollectorController.php:611
* @route '/api/collector/units/{unit_id}'
*/
unitDetails.url = (args: { unit_id: string | number } | [unit_id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { unit_id: args }
    }

    if (Array.isArray(args)) {
        args = {
            unit_id: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        unit_id: args.unit_id,
    }

    return unitDetails.definition.url
            .replace('{unit_id}', parsedArgs.unit_id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CollectorController::unitDetails
* @see app/Http/Controllers/Api/CollectorController.php:611
* @route '/api/collector/units/{unit_id}'
*/
unitDetails.get = (args: { unit_id: string | number } | [unit_id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: unitDetails.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::unitDetails
* @see app/Http/Controllers/Api/CollectorController.php:611
* @route '/api/collector/units/{unit_id}'
*/
unitDetails.head = (args: { unit_id: string | number } | [unit_id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: unitDetails.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::unitDetails
* @see app/Http/Controllers/Api/CollectorController.php:611
* @route '/api/collector/units/{unit_id}'
*/
const unitDetailsForm = (args: { unit_id: string | number } | [unit_id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: unitDetails.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::unitDetails
* @see app/Http/Controllers/Api/CollectorController.php:611
* @route '/api/collector/units/{unit_id}'
*/
unitDetailsForm.get = (args: { unit_id: string | number } | [unit_id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: unitDetails.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::unitDetails
* @see app/Http/Controllers/Api/CollectorController.php:611
* @route '/api/collector/units/{unit_id}'
*/
unitDetailsForm.head = (args: { unit_id: string | number } | [unit_id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: unitDetails.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

unitDetails.form = unitDetailsForm

/**
* @see \App\Http\Controllers\Api\CollectorController::wallet
* @see app/Http/Controllers/Api/CollectorController.php:686
* @route '/api/collector/wallet'
*/
export const wallet = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: wallet.url(options),
    method: 'get',
})

wallet.definition = {
    methods: ["get","head"],
    url: '/api/collector/wallet',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\CollectorController::wallet
* @see app/Http/Controllers/Api/CollectorController.php:686
* @route '/api/collector/wallet'
*/
wallet.url = (options?: RouteQueryOptions) => {
    return wallet.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CollectorController::wallet
* @see app/Http/Controllers/Api/CollectorController.php:686
* @route '/api/collector/wallet'
*/
wallet.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: wallet.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::wallet
* @see app/Http/Controllers/Api/CollectorController.php:686
* @route '/api/collector/wallet'
*/
wallet.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: wallet.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::wallet
* @see app/Http/Controllers/Api/CollectorController.php:686
* @route '/api/collector/wallet'
*/
const walletForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: wallet.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::wallet
* @see app/Http/Controllers/Api/CollectorController.php:686
* @route '/api/collector/wallet'
*/
walletForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: wallet.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::wallet
* @see app/Http/Controllers/Api/CollectorController.php:686
* @route '/api/collector/wallet'
*/
walletForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: wallet.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

wallet.form = walletForm

/**
* @see \App\Http\Controllers\Api\CollectorController::handover
* @see app/Http/Controllers/Api/CollectorController.php:461
* @route '/api/collector/handover'
*/
export const handover = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: handover.url(options),
    method: 'post',
})

handover.definition = {
    methods: ["post"],
    url: '/api/collector/handover',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\CollectorController::handover
* @see app/Http/Controllers/Api/CollectorController.php:461
* @route '/api/collector/handover'
*/
handover.url = (options?: RouteQueryOptions) => {
    return handover.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\CollectorController::handover
* @see app/Http/Controllers/Api/CollectorController.php:461
* @route '/api/collector/handover'
*/
handover.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: handover.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::handover
* @see app/Http/Controllers/Api/CollectorController.php:461
* @route '/api/collector/handover'
*/
const handoverForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: handover.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\CollectorController::handover
* @see app/Http/Controllers/Api/CollectorController.php:461
* @route '/api/collector/handover'
*/
handoverForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: handover.url(options),
    method: 'post',
})

handover.form = handoverForm

const CollectorController = { dashboard, dues, cleared, storePayment, reports, unitDetails, wallet, handover }

export default CollectorController