import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\AnnouncementController::index
* @see app/Http/Controllers/Api/AnnouncementController.php:20
* @route '/api/announcements'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/api/announcements',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\AnnouncementController::index
* @see app/Http/Controllers/Api/AnnouncementController.php:20
* @route '/api/announcements'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\AnnouncementController::index
* @see app/Http/Controllers/Api/AnnouncementController.php:20
* @route '/api/announcements'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\AnnouncementController::index
* @see app/Http/Controllers/Api/AnnouncementController.php:20
* @route '/api/announcements'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\AnnouncementController::index
* @see app/Http/Controllers/Api/AnnouncementController.php:20
* @route '/api/announcements'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\AnnouncementController::index
* @see app/Http/Controllers/Api/AnnouncementController.php:20
* @route '/api/announcements'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\AnnouncementController::index
* @see app/Http/Controllers/Api/AnnouncementController.php:20
* @route '/api/announcements'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\Api\AnnouncementController::show
* @see app/Http/Controllers/Api/AnnouncementController.php:182
* @route '/api/announcements/{announcement}'
*/
export const show = (args: { announcement: number | { id: number } } | [announcement: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/api/announcements/{announcement}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\AnnouncementController::show
* @see app/Http/Controllers/Api/AnnouncementController.php:182
* @route '/api/announcements/{announcement}'
*/
show.url = (args: { announcement: number | { id: number } } | [announcement: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { announcement: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { announcement: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            announcement: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        announcement: typeof args.announcement === 'object'
        ? args.announcement.id
        : args.announcement,
    }

    return show.definition.url
            .replace('{announcement}', parsedArgs.announcement.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\AnnouncementController::show
* @see app/Http/Controllers/Api/AnnouncementController.php:182
* @route '/api/announcements/{announcement}'
*/
show.get = (args: { announcement: number | { id: number } } | [announcement: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\AnnouncementController::show
* @see app/Http/Controllers/Api/AnnouncementController.php:182
* @route '/api/announcements/{announcement}'
*/
show.head = (args: { announcement: number | { id: number } } | [announcement: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\AnnouncementController::show
* @see app/Http/Controllers/Api/AnnouncementController.php:182
* @route '/api/announcements/{announcement}'
*/
const showForm = (args: { announcement: number | { id: number } } | [announcement: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\AnnouncementController::show
* @see app/Http/Controllers/Api/AnnouncementController.php:182
* @route '/api/announcements/{announcement}'
*/
showForm.get = (args: { announcement: number | { id: number } } | [announcement: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\AnnouncementController::show
* @see app/Http/Controllers/Api/AnnouncementController.php:182
* @route '/api/announcements/{announcement}'
*/
showForm.head = (args: { announcement: number | { id: number } } | [announcement: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\Api\AnnouncementController::acknowledge
* @see app/Http/Controllers/Api/AnnouncementController.php:207
* @route '/api/announcements/{announcement}/acknowledge'
*/
export const acknowledge = (args: { announcement: number | { id: number } } | [announcement: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: acknowledge.url(args, options),
    method: 'post',
})

acknowledge.definition = {
    methods: ["post"],
    url: '/api/announcements/{announcement}/acknowledge',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\AnnouncementController::acknowledge
* @see app/Http/Controllers/Api/AnnouncementController.php:207
* @route '/api/announcements/{announcement}/acknowledge'
*/
acknowledge.url = (args: { announcement: number | { id: number } } | [announcement: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { announcement: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { announcement: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            announcement: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        announcement: typeof args.announcement === 'object'
        ? args.announcement.id
        : args.announcement,
    }

    return acknowledge.definition.url
            .replace('{announcement}', parsedArgs.announcement.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\AnnouncementController::acknowledge
* @see app/Http/Controllers/Api/AnnouncementController.php:207
* @route '/api/announcements/{announcement}/acknowledge'
*/
acknowledge.post = (args: { announcement: number | { id: number } } | [announcement: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: acknowledge.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\AnnouncementController::acknowledge
* @see app/Http/Controllers/Api/AnnouncementController.php:207
* @route '/api/announcements/{announcement}/acknowledge'
*/
const acknowledgeForm = (args: { announcement: number | { id: number } } | [announcement: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: acknowledge.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\AnnouncementController::acknowledge
* @see app/Http/Controllers/Api/AnnouncementController.php:207
* @route '/api/announcements/{announcement}/acknowledge'
*/
acknowledgeForm.post = (args: { announcement: number | { id: number } } | [announcement: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: acknowledge.url(args, options),
    method: 'post',
})

acknowledge.form = acknowledgeForm

const AnnouncementController = { index, show, acknowledge }

export default AnnouncementController