import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Api\AdController::slots
* @see app/Http/Controllers/Api/AdController.php:19
* @route '/api/ads/slots'
*/
export const slots = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: slots.url(options),
    method: 'get',
})

slots.definition = {
    methods: ["get","head"],
    url: '/api/ads/slots',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\AdController::slots
* @see app/Http/Controllers/Api/AdController.php:19
* @route '/api/ads/slots'
*/
slots.url = (options?: RouteQueryOptions) => {
    return slots.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\AdController::slots
* @see app/Http/Controllers/Api/AdController.php:19
* @route '/api/ads/slots'
*/
slots.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: slots.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\AdController::slots
* @see app/Http/Controllers/Api/AdController.php:19
* @route '/api/ads/slots'
*/
slots.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: slots.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\AdController::slots
* @see app/Http/Controllers/Api/AdController.php:19
* @route '/api/ads/slots'
*/
const slotsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: slots.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\AdController::slots
* @see app/Http/Controllers/Api/AdController.php:19
* @route '/api/ads/slots'
*/
slotsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: slots.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\AdController::slots
* @see app/Http/Controllers/Api/AdController.php:19
* @route '/api/ads/slots'
*/
slotsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: slots.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

slots.form = slotsForm

/**
* @see \App\Http\Controllers\Api\AdController::create
* @see app/Http/Controllers/Api/AdController.php:42
* @route '/api/ads/create'
*/
export const create = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: create.url(options),
    method: 'post',
})

create.definition = {
    methods: ["post"],
    url: '/api/ads/create',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Api\AdController::create
* @see app/Http/Controllers/Api/AdController.php:42
* @route '/api/ads/create'
*/
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\AdController::create
* @see app/Http/Controllers/Api/AdController.php:42
* @route '/api/ads/create'
*/
create.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: create.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\AdController::create
* @see app/Http/Controllers/Api/AdController.php:42
* @route '/api/ads/create'
*/
const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: create.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Api\AdController::create
* @see app/Http/Controllers/Api/AdController.php:42
* @route '/api/ads/create'
*/
createForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: create.url(options),
    method: 'post',
})

create.form = createForm

/**
* @see \App\Http\Controllers\Api\AdController::myAds
* @see app/Http/Controllers/Api/AdController.php:109
* @route '/api/ads/my-ads'
*/
export const myAds = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: myAds.url(options),
    method: 'get',
})

myAds.definition = {
    methods: ["get","head"],
    url: '/api/ads/my-ads',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\AdController::myAds
* @see app/Http/Controllers/Api/AdController.php:109
* @route '/api/ads/my-ads'
*/
myAds.url = (options?: RouteQueryOptions) => {
    return myAds.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\AdController::myAds
* @see app/Http/Controllers/Api/AdController.php:109
* @route '/api/ads/my-ads'
*/
myAds.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: myAds.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\AdController::myAds
* @see app/Http/Controllers/Api/AdController.php:109
* @route '/api/ads/my-ads'
*/
myAds.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: myAds.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\AdController::myAds
* @see app/Http/Controllers/Api/AdController.php:109
* @route '/api/ads/my-ads'
*/
const myAdsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: myAds.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\AdController::myAds
* @see app/Http/Controllers/Api/AdController.php:109
* @route '/api/ads/my-ads'
*/
myAdsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: myAds.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\AdController::myAds
* @see app/Http/Controllers/Api/AdController.php:109
* @route '/api/ads/my-ads'
*/
myAdsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: myAds.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

myAds.form = myAdsForm

/**
* @see \App\Http\Controllers\Api\AdController::active
* @see app/Http/Controllers/Api/AdController.php:123
* @route '/api/ads/active'
*/
export const active = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: active.url(options),
    method: 'get',
})

active.definition = {
    methods: ["get","head"],
    url: '/api/ads/active',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Api\AdController::active
* @see app/Http/Controllers/Api/AdController.php:123
* @route '/api/ads/active'
*/
active.url = (options?: RouteQueryOptions) => {
    return active.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Api\AdController::active
* @see app/Http/Controllers/Api/AdController.php:123
* @route '/api/ads/active'
*/
active.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: active.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\AdController::active
* @see app/Http/Controllers/Api/AdController.php:123
* @route '/api/ads/active'
*/
active.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: active.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Api\AdController::active
* @see app/Http/Controllers/Api/AdController.php:123
* @route '/api/ads/active'
*/
const activeForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: active.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\AdController::active
* @see app/Http/Controllers/Api/AdController.php:123
* @route '/api/ads/active'
*/
activeForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: active.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Api\AdController::active
* @see app/Http/Controllers/Api/AdController.php:123
* @route '/api/ads/active'
*/
activeForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: active.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

active.form = activeForm

const AdController = { slots, create, myAds, active }

export default AdController