<?php

use Illuminate\Foundation\Application;
use Illuminate\Http\Request;

define('LARAVEL_START', microtime(true));

// Determine if the application is in maintenance mode...
if (file_exists($maintenance = __DIR__.'/../storage/framework/maintenance.php')) {
    require $maintenance;
}

// Register the Composer autoloader...
require __DIR__.'/../vendor/autoload.php';

// Set drivers to file/sync if app is not installed (before Laravel boots)
$installedFile = __DIR__.'/../storage/app/private/installed.json';
if (!file_exists($installedFile)) {
    $_ENV['SESSION_DRIVER'] = 'file';
    $_ENV['CACHE_STORE'] = 'file';
    $_ENV['QUEUE_CONNECTION'] = 'sync';
    putenv('SESSION_DRIVER=file');
    putenv('CACHE_STORE=file');
    putenv('QUEUE_CONNECTION=sync');
}

// Bootstrap Laravel and handle the request...
/** @var Application $app */
$app = require_once __DIR__.'/../bootstrap/app.php';

$app->handleRequest(Request::capture());
