# Setup (Local / Offline)

## Requirements

- PHP 8.2+
- Composer
- Node.js + npm
- A database (SQLite for local dev is fine)

## Install

From the project root:

```bash
composer install
cp .env.example .env
php artisan key:generate
php artisan migrate
npm install
npm run dev
```

## Environment variables

See `.env.example` for a full list. Important ones:

- `APP_ENV`, `APP_DEBUG`, `APP_URL`
- `DB_*` (or use SQLite with `DB_CONNECTION=sqlite`)
- **Razorpay webhook verification (database-driven)**
  - Society payments: set `razorpay_webhook_secret` in **Society Admin → Settings → Payment**
  - SaaS subscription payments: set `razorpay_webhook_secret` in **Super Admin → Settings → Payments**

## Build for production

```bash
npm run build
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

