# Security Notes (Review Fixes)

## Razorpay webhook authentication (fixed)

- Endpoint: `POST /api/webhooks/razorpay`
- Status: **Signature verification enforced**

### How it works

The webhook handler verifies the `X-Razorpay-Signature` header using:

- Body: raw request body
- Secret: **database-driven** webhook secret
  - Society payments: `society_settings.razorpay_webhook_secret`
  - SaaS subscription payments: `system_settings[key=razorpay_webhook_secret]`
- Algorithm: `HMAC-SHA256`

If the header is missing or invalid, the request is rejected with `401`.

## OTP returned in API response (fixed)

- Endpoint: `POST /api/send-otp`
- Status: **OTP is never returned in the response**

For local/testing only, the OTP is written to logs (so developers can test without an SMS provider).

## Payment secret keys exposure (fixed)

The `SocietyController::info` API response no longer includes any payment gateway **secret keys** (they are always `null` in the response).

## PayPal SDK (fixed)

The abandoned `paypal/rest-api-sdk-php` dependency has been removed.

We now use PayPal’s official server SDK package:

- Package: `paypal/paypal-server-sdk`
- Reference: `https://developer.paypal.com/serversdk/php/getting-started/how-to-get-started`

