# Payments

## Supported gateways

- Razorpay
- Stripe
- PayPal

## Gateway selection

Payment gateways are exposed to clients via the `paymentConfig` endpoints (public keys only). Secret keys must never be exposed to clients.

## PayPal (Server SDK)

This project uses PayPal’s server SDK:

- Package: `paypal/paypal-server-sdk`
- Docs: `https://developer.paypal.com/serversdk/php/getting-started/how-to-get-started`

Implementation: `app/Services/PaymentGateway/PayPalGateway.php`

### Flow

1. **Create order** (server): creates an order with intent `CAPTURE` and returns:
   - `order_id`
   - `approval_url` (rel=`approve`) for redirect-based approval
2. **Capture order** (server): captures the order after approval and returns:
   - `payment_id` (capture id when available)
   - `order_id`

## Razorpay webhook

Endpoint: `POST /api/webhooks/razorpay`

Required config (database-driven):

- **Society payments**: set `razorpay_webhook_secret` in **Society Admin → Settings → Payment**
- **SaaS subscription payments**: set `razorpay_webhook_secret` in **Super Admin → Settings → Payments**

The handler validates `X-Razorpay-Signature` using the appropriate secret from the database before processing any event.

