<?php

namespace Database\Seeders;

use App\Models\Role;
use App\Models\Society;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $society = Society::first();

        if (! $society) {
            $this->command->warn('No society found. Please run SocietySeeder first.');

            return;
        }

        // Web Admins
        // Note: admin@societify.com is reserved for SuperAdmin (separate table)
        // Society Admin uses societyadmin@societify.com
        $societyAdmin = User::where('email', 'societyadmin@societify.com')
            ->orWhere('phone', '9876543210')
            ->first();

        if ($societyAdmin) {
            $societyAdmin->update([
                'email' => 'societyadmin@societify.com',
                'society_id' => $society->id,
                'role_id' => Role::where('name', 'society_admin')->first()->id,
                'name' => 'Unique Society Admin',
                'phone' => '9876543210',
                'password' => Hash::make('password'),
                'status' => 'active',
                'directory_visible' => false,
                'email_verified_at' => now(),
            ]);
        } else {
            User::create([
                'email' => 'societyadmin@societify.com',
                'society_id' => $society->id,
                'role_id' => Role::where('name', 'society_admin')->first()->id,
                'name' => 'Unique Society Admin',
                'phone' => '9876543210',
                'password' => Hash::make('password'),
                'status' => 'active',
                'directory_visible' => false,
                'email_verified_at' => now(),
            ]);
        }

        // Update or create Sub Admin
        $subAdmin = User::where('email', 'subadmin@societify.com')
            ->orWhere('phone', '9876543211')
            ->first();

        if ($subAdmin) {
            $subAdmin->update([
                'email' => 'subadmin@societify.com',
                'society_id' => $society->id,
                'role_id' => Role::where('name', 'sub_admin')->first()->id,
                'name' => 'Sub Admin User',
                'phone' => '9876543211',
                'password' => Hash::make('password'),
                'status' => 'active',
                'directory_visible' => false,
                'email_verified_at' => now(),
            ]);
        } else {
            User::create([
                'email' => 'subadmin@societify.com',
                'society_id' => $society->id,
                'role_id' => Role::where('name', 'sub_admin')->first()->id,
                'name' => 'Sub Admin User',
                'phone' => '9876543211',
                'password' => Hash::make('password'),
                'status' => 'active',
                'directory_visible' => false,
                'email_verified_at' => now(),
            ]);
        }

        // Update or create Accountant
        $accountant = User::where('email', 'accountant@societify.com')
            ->orWhere('email', 'accountant@societify.com')
            ->orWhere('phone', '9876543212')
            ->first();

        if ($accountant) {
            $accountant->update([
                'email' => 'accountant@societify.com',
                'society_id' => $society->id,
                'role_id' => Role::where('name', 'accountant')->first()->id,
                'name' => 'CA Unique Accountant',
                'phone' => '9876543212',
                'password' => Hash::make('password'),
                'status' => 'active',
                'directory_visible' => false,
                'email_verified_at' => now(),
            ]);
        } else {
            User::create([
                'email' => 'accountant@societify.com',
                'society_id' => $society->id,
                'role_id' => Role::where('name', 'accountant')->first()->id,
                'name' => 'CA Unique Accountant',
                'phone' => '9876543212',
                'password' => Hash::make('password'),
                'status' => 'active',
                'directory_visible' => false,
                'email_verified_at' => now(),
            ]);
        }

        // Mobile Users
        User::firstOrCreate(
            ['phone' => '9876543213'],
            [
                'society_id' => $society->id,
                'role_id' => Role::where('name', 'resident')->first()->id,
                'name' => 'John Resident',
                'phone' => '9876543213',
                'password' => Hash::make('password'),
                'unit_id' => null, // Will be set when units are created
                'fcm_token' => 'fcm_demo_token_123',
                'status' => 'active',
                'directory_visible' => true,
            ]
        );

        User::firstOrCreate(
            ['phone' => '9876543214'],
            [
                'society_id' => $society->id,
                'role_id' => Role::where('name', 'guard')->first()->id,
                'name' => 'Security Guard Raju',
                'phone' => '9876543214',
                'password' => Hash::make('password'),
                'fcm_token' => 'fcm_demo_token_456',
                'status' => 'active',
                'directory_visible' => true,
            ]
        );
    }
}
