<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use App\Models\SystemSetting;
use Illuminate\Database\Seeder;

class SystemSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            // Branding
            [
                'key' => 'app_name',
                'value' => 'Societify',
                'group' => 'branding',
                'type' => 'text',
                'description' => 'The name of the application displayed in the title and navbar.',
                'is_public' => true,
            ],
            [
                'key' => 'app_logo',
                'value' => null,
                'group' => 'branding',
                'type' => 'image',
                'description' => 'The main logo of the application (for light backgrounds).',
                'is_public' => true,
            ],
            [
                'key' => 'app_logo_dark',
                'value' => null,
                'group' => 'branding',
                'type' => 'image',
                'description' => 'The logo for dark mode (white/light logo for dark backgrounds).',
                'is_public' => true,
            ],
            [
                'key' => 'app_favicon',
                'value' => null,
                'group' => 'branding',
                'type' => 'image',
                'description' => 'The favicon displayed in browser tabs.',
                'is_public' => true,
            ],
            [
                'key' => 'primary_color',
                'value' => '#10b981', // emerald-500
                'group' => 'branding',
                'type' => 'color',
                'description' => 'The primary brand color.',
                'is_public' => true,
            ],
            
            // Features
            [
                'key' => 'enable_landing_page',
                'value' => '1',
                'group' => 'features',
                'type' => 'boolean',
                'description' => 'Enable the public landing page.',
                'is_public' => true,
            ],
            [
                'key' => 'enable_pricing_page',
                'value' => '1',
                'group' => 'features',
                'type' => 'boolean',
                'description' => 'Enable the public pricing page.',
                'is_public' => true,
            ],
            [
                'key' => 'enable_registration',
                'value' => '1',
                'group' => 'features',
                'type' => 'boolean',
                'description' => 'Allow new societies to register.',
                'is_public' => true,
            ],

            // SEO
            [
                'key' => 'meta_title',
                'value' => 'Societify - Modern Society Management',
                'group' => 'seo',
                'type' => 'text',
                'description' => 'Default meta title for public pages.',
                'is_public' => true,
            ],
            [
                'key' => 'meta_description',
                'value' => 'Streamline your housing society management with Societify.',
                'group' => 'seo',
                'type' => 'textarea',
                'description' => 'Default meta description for public pages.',
                'is_public' => true,
            ],

            // Payment Gateways
            // Stripe
            [
                'key' => 'stripe_enabled',
                'value' => '0',
                'group' => 'payment_gateways',
                'type' => 'boolean',
                'description' => 'Enable Stripe payments.',
                'is_public' => true,
            ],
            [
                'key' => 'stripe_key',
                'value' => '',
                'group' => 'payment_gateways',
                'type' => 'text',
                'description' => 'Stripe Publishable Key.',
                'is_public' => true,
            ],
            [
                'key' => 'stripe_secret',
                'value' => '',
                'group' => 'payment_gateways',
                'type' => 'text',
                'description' => 'Stripe Secret Key.',
                'is_public' => false,
            ],
            // Razorpay
            [
                'key' => 'razorpay_enabled',
                'value' => '0',
                'group' => 'payment_gateways',
                'type' => 'boolean',
                'description' => 'Enable Razorpay payments.',
                'is_public' => true,
            ],
            [
                'key' => 'razorpay_key',
                'value' => '',
                'group' => 'payment_gateways',
                'type' => 'text',
                'description' => 'Razorpay Key ID.',
                'is_public' => true,
            ],
            [
                'key' => 'razorpay_secret',
                'value' => '',
                'group' => 'payment_gateways',
                'type' => 'text',
                'description' => 'Razorpay Key Secret.',
                'is_public' => false,
            ],
            // PayPal
            [
                'key' => 'paypal_enabled',
                'value' => '0',
                'group' => 'payment_gateways',
                'type' => 'boolean',
                'description' => 'Enable PayPal payments.',
                'is_public' => true,
            ],
            [
                'key' => 'paypal_client_id',
                'value' => '',
                'group' => 'payment_gateways',
                'type' => 'text',
                'description' => 'PayPal Client ID.',
                'is_public' => true,
            ],
            [
                'key' => 'paypal_secret',
                'value' => '',
                'group' => 'payment_gateways',
                'type' => 'text',
                'description' => 'PayPal Secret.',
                'is_public' => false,
            ],

            // Email Configuration (SMTP)
            [
                'key' => 'mail_mailer',
                'value' => 'smtp',
                'group' => 'email',
                'type' => 'text',
                'description' => 'Mail driver (e.g., smtp).',
                'is_public' => false,
            ],
            [
                'key' => 'mail_host',
                'value' => 'smtp.mailtrap.io',
                'group' => 'email',
                'type' => 'text',
                'description' => 'SMTP Host.',
                'is_public' => false,
            ],
            [
                'key' => 'mail_port',
                'value' => '2525',
                'group' => 'email',
                'type' => 'number',
                'description' => 'SMTP Port.',
                'is_public' => false,
            ],
            [
                'key' => 'mail_username',
                'value' => '',
                'group' => 'email',
                'type' => 'text',
                'description' => 'SMTP Username.',
                'is_public' => false,
            ],
            [
                'key' => 'mail_password',
                'value' => '',
                'group' => 'email',
                'type' => 'text',
                'description' => 'SMTP Password.',
                'is_public' => false,
            ],
            [
                'key' => 'mail_encryption',
                'value' => 'tls',
                'group' => 'email',
                'type' => 'text',
                'description' => 'SMTP Encryption (tls/ssl).',
                'is_public' => false,
            ],
            [
                'key' => 'mail_from_address',
                'value' => 'hello@example.com',
                'group' => 'email',
                'type' => 'text',
                'description' => 'From Email Address.',
                'is_public' => false,
            ],
            [
                'key' => 'mail_from_name',
                'value' => 'Societify',
                'group' => 'email',
                'type' => 'text',
                'description' => 'From Name.',
                'is_public' => false,
            ],
            // Legal Pages
            [
                'key' => 'privacy_policy',
                'value' => '<h1>Privacy Policy</h1><p>Your privacy is important to us...</p>',
                'group' => 'legal',
                'type' => 'textarea',
                'description' => 'Content for the Privacy Policy page.',
                'is_public' => true,
            ],
            [
                'key' => 'terms_of_service',
                'value' => '<h1>Terms of Service</h1><p>By using our service, you agree...</p>',
                'group' => 'legal',
                'type' => 'textarea',
                'description' => 'Content for the Terms of Service page.',
                'is_public' => true,
            ],
            [
                'key' => 'refund_policy',
                'value' => '<h1>Refund Policy</h1><p>Our refund policy is as follows...</p>',
                'group' => 'legal',
                'type' => 'textarea',
                'description' => 'Content for the Refund Policy page.',
                'is_public' => true,
            ],
            [
                'key' => 'about_us',
                'value' => '<h1>About Us</h1><p>We are a company dedicated to...</p>',
                'group' => 'legal',
                'type' => 'textarea',
                'description' => 'Content for the About Us page.',
                'is_public' => true,
            ],
        ];

        foreach ($settings as $setting) {
            SystemSetting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }
    }
}
