<?php

namespace Database\Seeders;

use App\Models\SubscriptionPlan;
use Illuminate\Database\Seeder;

class SubscriptionPlanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $plans = [
            [
                'name' => 'basic',
                'display_name' => 'Basic Plan',
                'description' => 'Perfect for small societies with basic needs',
                'monthly_price' => 0,
                'quarterly_price' => 0,
                'annual_price' => 0,
                'max_users' => 100,
                'max_units' => 500,
                'max_buildings' => 10,
                'storage_gb' => 5,
                'sms_enabled' => false,
                'whatsapp_enabled' => false,
                'email_enabled' => true,
                'fcm_enabled' => true,
                'advanced_reports' => false,
                'api_access' => false,
                'custom_branding' => false,
                'priority_support' => false,
                'white_label' => false,
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'premium',
                'display_name' => 'Premium Plan',
                'description' => 'Ideal for medium to large societies with advanced features',
                'monthly_price' => 5000,
                'quarterly_price' => 13500, // 10% discount
                'annual_price' => 48000, // 20% discount
                'max_users' => 500,
                'max_units' => 2000,
                'max_buildings' => 50,
                'storage_gb' => 50,
                'sms_enabled' => true,
                'whatsapp_enabled' => true,
                'email_enabled' => true,
                'fcm_enabled' => true,
                'advanced_reports' => true,
                'api_access' => true,
                'custom_branding' => true,
                'priority_support' => true,
                'white_label' => false,
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'enterprise',
                'display_name' => 'Enterprise Plan',
                'description' => 'For large societies requiring unlimited features and white-label solution',
                'monthly_price' => 15000,
                'quarterly_price' => 40500, // 10% discount
                'annual_price' => 144000, // 20% discount
                'max_users' => 9999, // Unlimited
                'max_units' => 9999, // Unlimited
                'max_buildings' => 9999, // Unlimited
                'storage_gb' => 200,
                'sms_enabled' => true,
                'whatsapp_enabled' => true,
                'email_enabled' => true,
                'fcm_enabled' => true,
                'advanced_reports' => true,
                'api_access' => true,
                'custom_branding' => true,
                'priority_support' => true,
                'white_label' => true,
                'is_active' => true,
                'sort_order' => 3,
            ],
        ];

        foreach ($plans as $plan) {
            SubscriptionPlan::firstOrCreate(
                ['name' => $plan['name']],
                $plan
            );
        }
    }
}
