<?php

namespace Database\Seeders;

use App\Models\PlatformFee;
use App\Models\Society;
use Illuminate\Database\Seeder;

class SocietySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $society = Society::firstOrCreate(
            ['registration_no' => 'MH/RES/2025/001'],
            [
                'name' => 'Unique Residency',
                'code' => 'UNIQUE001',
                'address' => '123 Unique Society Road',
                'city' => 'Pune',
                'state' => 'Maharashtra',
                'pincode' => '411001',
                'status' => 'active',
                'platform_fee_amount' => 2500,
                'platform_fee_frequency' => 'monthly',
            ]
        );

        PlatformFee::firstOrCreate(
            ['society_id' => $society->id],
            [
                'amount' => 2500,
                'frequency' => 'monthly',
                'start_date' => now(),
                'status' => 'pending',
            ]
        );
    }
}
