<?php

namespace Database\Seeders;

use App\Models\Role;
use Illuminate\Database\Seeder;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $roles = [
            [
                'name' => 'society_admin',
                'display_name' => 'Society Admin',
                'description' => 'Web Admin (Full Access)',
            ],
            [
                'name' => 'sub_admin',
                'display_name' => 'Sub Admin',
                'description' => 'Web Admin (Limited)',
            ],
            [
                'name' => 'accountant',
                'display_name' => 'Accountant',
                'description' => 'Web Admin (Financial)',
            ],
            [
                'name' => 'collector',
                'display_name' => 'Collector',
                'description' => 'API (Payment Collection & Reports)',
            ],
            [
                'name' => 'resident',
                'display_name' => 'Resident',
                'description' => 'Mobile (Bills/Maintenance)',
            ],
            [
                'name' => 'guard',
                'display_name' => 'Guard',
                'description' => 'Mobile (Visitors)',
            ],
            [
                'name' => 'vendor',
                'display_name' => 'Vendor',
                'description' => 'Mobile (Jobs)',
            ],
            [
                'name' => 'staff',
                'display_name' => 'Staff',
                'description' => 'Mobile (Operations)',
            ],
        ];

        foreach ($roles as $role) {
            Role::firstOrCreate(
                ['name' => $role['name']],
                $role
            );
        }
    }
}
