<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Database\Seeder;

class RolePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Society Admin - Full Access
        $societyAdmin = Role::where('name', 'society_admin')->first();
        if ($societyAdmin) {
            $societyAdmin->permissions()->sync(Permission::all()->pluck('id'));
        }

        // Sub-Admin - Limited Access
        $subAdmin = Role::where('name', 'sub_admin')->first();
        if ($subAdmin) {
            $subAdminPermissions = Permission::whereIn('name', [
                'dashboard.view',
                'residents.view',
                'residents.create',
                'residents.edit',
                'buildings.view',
                'buildings.create',
                'buildings.edit',
                'units.view',
                'units.create',
                'units.edit',
                'billing.bills.view',
                'billing.bills.create',
                'billing.bills.generate',
                'expenses.view',
                'expenses.create',
                'expenses.edit',
                'maintenance.view',
                'maintenance.create',
                'maintenance.edit',
                'maintenance.assign',
                'maintenance.update_status',
                'visitors.view',
                'visitors.create',
                'visitors.check_in',
                'visitors.check_out',
                'visitors.approve',
                'visitors.reject',
                'announcements.view',
                'announcements.create',
                'announcements.edit',
                'announcements.publish',
                'directory.view',
            ])->pluck('id');
            $subAdmin->permissions()->sync($subAdminPermissions);
        }

        // Accountant - Financial Access Only
        $accountant = Role::where('name', 'accountant')->first();
        if ($accountant) {
            $accountantPermissions = Permission::whereIn('name', [
                'dashboard.view',
                'billing.cycles.view',
                'billing.cycles.create',
                'billing.cycles.generate',
                'billing.bills.view',
                'billing.bills.create',
                'billing.bills.revise',
                'billing.bills.generate',
                'payments.view',
                'payments.create',
                'payments.reconcile',
                'bank_accounts.view',
                'bank_accounts.create',
                'bank_accounts.edit',
                'bank_accounts.update_balance',
                'bank_accounts.transactions',
                'bank_accounts.reconcile',
                'expenses.view',
                'expenses.create',
                'expenses.edit',
                'expenses.delete',
                'reports.view',
                'reports.financial',
                'reports.export',
            ])->pluck('id');
            $accountant->permissions()->sync($accountantPermissions);
        }

        // Collector - Payment Collection & Reports (API Only)
        $collector = Role::where('name', 'collector')->first();
        if ($collector) {
            $collectorPermissions = Permission::whereIn('name', [
                'collector.payments.view',
                'collector.payments.create',
                'collector.dues.view',
                'collector.cleared.view',
                'collector.reports.view',
                'collector.units.view',
                'billing.bills.view', // Need to view bills to collect payments
                'units.view', // Need to view units
            ])->pluck('id');
            $collector->permissions()->sync($collectorPermissions);
        }
    }
}
