<?php

namespace Database\Seeders;

use App\Models\Permission;
use Illuminate\Database\Seeder;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            // Dashboard
            ['name' => 'dashboard.view', 'display_name' => 'View Dashboard', 'group' => 'dashboard', 'sort_order' => 10],

            // Society Settings
            ['name' => 'society.settings.view', 'display_name' => 'View Society Settings', 'group' => 'settings', 'sort_order' => 20],
            ['name' => 'society.settings.edit', 'display_name' => 'Edit Society Settings', 'group' => 'settings', 'sort_order' => 21],

            // Residents
            ['name' => 'residents.view', 'display_name' => 'View Residents', 'group' => 'residents', 'sort_order' => 30],
            ['name' => 'residents.create', 'display_name' => 'Create Residents', 'group' => 'residents', 'sort_order' => 31],
            ['name' => 'residents.edit', 'display_name' => 'Edit Residents', 'group' => 'residents', 'sort_order' => 32],
            ['name' => 'residents.delete', 'display_name' => 'Delete Residents', 'group' => 'residents', 'sort_order' => 33],

            // Buildings
            ['name' => 'buildings.view', 'display_name' => 'View Buildings', 'group' => 'buildings', 'sort_order' => 40],
            ['name' => 'buildings.create', 'display_name' => 'Create Buildings', 'group' => 'buildings', 'sort_order' => 41],
            ['name' => 'buildings.edit', 'display_name' => 'Edit Buildings', 'group' => 'buildings', 'sort_order' => 42],
            ['name' => 'buildings.delete', 'display_name' => 'Delete Buildings', 'group' => 'buildings', 'sort_order' => 43],

            // Units
            ['name' => 'units.view', 'display_name' => 'View Units', 'group' => 'units', 'sort_order' => 50],
            ['name' => 'units.create', 'display_name' => 'Create Units', 'group' => 'units', 'sort_order' => 51],
            ['name' => 'units.edit', 'display_name' => 'Edit Units', 'group' => 'units', 'sort_order' => 52],
            ['name' => 'units.delete', 'display_name' => 'Delete Units', 'group' => 'units', 'sort_order' => 53],

            // Billing - Cycles
            ['name' => 'billing.cycles.view', 'display_name' => 'View Bill Cycles', 'group' => 'billing', 'sort_order' => 60],
            ['name' => 'billing.cycles.create', 'display_name' => 'Create Bill Cycles', 'group' => 'billing', 'sort_order' => 61],
            ['name' => 'billing.cycles.generate', 'display_name' => 'Generate Bills from Cycle', 'group' => 'billing', 'sort_order' => 62],

            // Billing - Bills
            ['name' => 'billing.bills.view', 'display_name' => 'View Bills', 'group' => 'billing', 'sort_order' => 70],
            ['name' => 'billing.bills.create', 'display_name' => 'Create Bills', 'group' => 'billing', 'sort_order' => 71],
            ['name' => 'billing.bills.revise', 'display_name' => 'Revise Bills', 'group' => 'billing', 'sort_order' => 72],
            ['name' => 'billing.bills.generate', 'display_name' => 'Generate Bills', 'group' => 'billing', 'sort_order' => 73],

            // Payments
            ['name' => 'payments.view', 'display_name' => 'View Payments', 'group' => 'payments', 'sort_order' => 80],
            ['name' => 'payments.create', 'display_name' => 'Create Payments', 'group' => 'payments', 'sort_order' => 81],
            ['name' => 'payments.reconcile', 'display_name' => 'Reconcile Payments', 'group' => 'payments', 'sort_order' => 82],

            // Bank Accounts
            ['name' => 'bank_accounts.view', 'display_name' => 'View Bank Accounts', 'group' => 'bank_accounts', 'sort_order' => 90],
            ['name' => 'bank_accounts.create', 'display_name' => 'Create Bank Accounts', 'group' => 'bank_accounts', 'sort_order' => 91],
            ['name' => 'bank_accounts.edit', 'display_name' => 'Edit Bank Accounts', 'group' => 'bank_accounts', 'sort_order' => 92],
            ['name' => 'bank_accounts.update_balance', 'display_name' => 'Update Bank Balance', 'group' => 'bank_accounts', 'sort_order' => 93],
            ['name' => 'bank_accounts.transactions', 'display_name' => 'View Bank Transactions', 'group' => 'bank_accounts', 'sort_order' => 94],
            ['name' => 'bank_accounts.reconcile', 'display_name' => 'Reconcile Bank Accounts', 'group' => 'bank_accounts', 'sort_order' => 95],

            // Expenses
            ['name' => 'expenses.view', 'display_name' => 'View Expenses', 'group' => 'expenses', 'sort_order' => 100],
            ['name' => 'expenses.create', 'display_name' => 'Create Expenses', 'group' => 'expenses', 'sort_order' => 101],
            ['name' => 'expenses.edit', 'display_name' => 'Edit Expenses', 'group' => 'expenses', 'sort_order' => 102],
            ['name' => 'expenses.delete', 'display_name' => 'Delete Expenses', 'group' => 'expenses', 'sort_order' => 103],

            // Maintenance
            ['name' => 'maintenance.view', 'display_name' => 'View Maintenance Tickets', 'group' => 'maintenance', 'sort_order' => 110],
            ['name' => 'maintenance.create', 'display_name' => 'Create Maintenance Tickets', 'group' => 'maintenance', 'sort_order' => 111],
            ['name' => 'maintenance.assign', 'display_name' => 'Assign Maintenance Tickets', 'group' => 'maintenance', 'sort_order' => 112],
            ['name' => 'maintenance.update_status', 'display_name' => 'Update Maintenance Status', 'group' => 'maintenance', 'sort_order' => 113],
            ['name' => 'maintenance.resolve', 'display_name' => 'Resolve Maintenance Tickets', 'group' => 'maintenance', 'sort_order' => 114],

            // Visitors
            ['name' => 'visitors.view', 'display_name' => 'View Visitors', 'group' => 'visitors', 'sort_order' => 120],
            ['name' => 'visitors.create', 'display_name' => 'Create Visitors', 'group' => 'visitors', 'sort_order' => 121],
            ['name' => 'visitors.check_in', 'display_name' => 'Check In Visitors', 'group' => 'visitors', 'sort_order' => 122],
            ['name' => 'visitors.check_out', 'display_name' => 'Check Out Visitors', 'group' => 'visitors', 'sort_order' => 123],
            ['name' => 'visitors.approve', 'display_name' => 'Approve Visitors', 'group' => 'visitors', 'sort_order' => 124],
            ['name' => 'visitors.reject', 'display_name' => 'Reject Visitors', 'group' => 'visitors', 'sort_order' => 125],

            // Announcements
            ['name' => 'announcements.view', 'display_name' => 'View Announcements', 'group' => 'announcements', 'sort_order' => 130],
            ['name' => 'announcements.create', 'display_name' => 'Create Announcements', 'group' => 'announcements', 'sort_order' => 131],
            ['name' => 'announcements.edit', 'display_name' => 'Edit Announcements', 'group' => 'announcements', 'sort_order' => 132],
            ['name' => 'announcements.delete', 'display_name' => 'Delete Announcements', 'group' => 'announcements', 'sort_order' => 133],
            ['name' => 'announcements.publish', 'display_name' => 'Publish/Unpublish Announcements', 'group' => 'announcements', 'sort_order' => 134],

            // Reports
            ['name' => 'reports.view', 'display_name' => 'View Reports', 'group' => 'reports', 'sort_order' => 140],
            ['name' => 'reports.financial', 'display_name' => 'View Financial Reports', 'group' => 'reports', 'sort_order' => 141],
            ['name' => 'reports.export', 'display_name' => 'Export Reports', 'group' => 'reports', 'sort_order' => 142],

            // Directory
            ['name' => 'directory.view', 'display_name' => 'View Directory', 'group' => 'directory', 'sort_order' => 145],

            // Team Management
            ['name' => 'team.view', 'display_name' => 'View Team', 'group' => 'team', 'sort_order' => 146],
            ['name' => 'team.create', 'display_name' => 'Create Team Members', 'group' => 'team', 'sort_order' => 147],
            ['name' => 'team.edit', 'display_name' => 'Edit Team Members', 'group' => 'team', 'sort_order' => 148],
            ['name' => 'team.delete', 'display_name' => 'Delete Team Members', 'group' => 'team', 'sort_order' => 149],

            // Collector (API - Payment Collection)
            ['name' => 'collector.payments.view', 'display_name' => 'View Payments', 'group' => 'collector', 'sort_order' => 150],
            ['name' => 'collector.payments.create', 'display_name' => 'Record Payments', 'group' => 'collector', 'sort_order' => 151],
            ['name' => 'collector.dues.view', 'display_name' => 'View Due List', 'group' => 'collector', 'sort_order' => 152],
            ['name' => 'collector.cleared.view', 'display_name' => 'View Cleared List', 'group' => 'collector', 'sort_order' => 153],
            ['name' => 'collector.reports.view', 'display_name' => 'View Collection Reports', 'group' => 'collector', 'sort_order' => 154],
            ['name' => 'collector.units.view', 'display_name' => 'View Unit Details', 'group' => 'collector', 'sort_order' => 155],
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(
                ['name' => $permission['name']],
                $permission
            );
        }
    }
}
