<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class FrontendContentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // 1. System Settings for Frontend Sections
        $settings = [
            // Hero Section
            [
                'key' => 'hero_title',
                'value' => 'Smart Society Management Platform',
                'group' => 'frontend',
                'type' => 'text',
                'description' => 'Main heading of the landing page.',
                'is_public' => true,
            ],
            [
                'key' => 'hero_subtitle',
                'value' => 'Streamline billing, visitor management, and community engagement. The #1 SaaS-based operating system for modern housing societies.',
                'group' => 'frontend',
                'type' => 'textarea',
                'description' => 'Subtitle of the landing page.',
                'is_public' => true,
            ],
            [
                'key' => 'hero_badge',
                'value' => 'Trusted by 500+ societies across India',
                'group' => 'frontend',
                'type' => 'text',
                'description' => 'Badge text displayed above value proposition.',
                'is_public' => true,
            ],
            
            // Section Toggles
            [
                'key' => 'enable_features_section',
                'value' => '1',
                'group' => 'frontend',
                'type' => 'boolean',
                'description' => 'Show features section.',
                'is_public' => true,
            ],
            [
                'key' => 'enable_testimonials_section',
                'value' => '1',
                'group' => 'frontend',
                'type' => 'boolean',
                'description' => 'Show testimonials section.',
                'is_public' => true,
            ],
            [
                'key' => 'enable_faq_section',
                'value' => '1',
                'group' => 'frontend',
                'type' => 'boolean',
                'description' => 'Show FAQ section.',
                'is_public' => true,
            ],
            [
                'key' => 'enable_cta_section',
                'value' => '1',
                'group' => 'frontend',
                'type' => 'boolean',
                'description' => 'Show bottom CTA section.',
                'is_public' => true,
            ],
        ];

        foreach ($settings as $setting) {
            \App\Models\SystemSetting::firstOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }

        // 2. CMS Features
        $features = [
            [
                'title' => 'Automated Billing',
                'description' => 'Generate maintenance bills automatically. Send reminders via SMS & Email. Accept payments online with 0% hassle.',
                'icon' => 'Receipt',
                'sort_order' => 1,
            ],
            [
                'title' => 'Visitor Management',
                'description' => 'Secure your gate with app-based visitor tracking. OTP verification for guests, delivery, and cabs.',
                'icon' => 'ShieldCheck',
                'sort_order' => 2,
            ],
            [
                'title' => 'Complaint Redressal',
                'description' => 'Track complaints from open to close. Keep residents informed with real-time status updates.',
                'icon' => 'MessageSquareWarning',
                'sort_order' => 3,
            ],
            [
                'title' => 'Financial Reports',
                'description' => 'Transparency at its best. View income, expense, and defaulter reports in one click.',
                'icon' => 'BarChart3',
                'sort_order' => 4,
            ],
            [
                'title' => 'Smart Notices',
                'description' => 'Stop pasting paper notices. Publish digital notices instantly to all residents\' phones.',
                'icon' => 'Bell',
                'sort_order' => 5,
            ],
            [
                'title' => 'Facility Booking',
                'description' => 'Manage clubhouse, tennis court, and pool bookings effortlessly. No more conflicts.',
                'icon' => 'CalendarDays',
                'sort_order' => 6,
            ],
        ];

        foreach ($features as $feature) {
            \App\Models\CmsFeature::firstOrCreate(
                ['title' => $feature['title']],
                $feature
            );
        }

        // 3. CMS FAQs
        $faqs = [
            [
                'question' => 'Is this a SaaS-based platform?',
                'answer' => 'Yes, Societify is a 100% cloud-based SaaS platform. You don\'t need to install any servers or hardware. Just login and start managing.',
                'sort_order' => 1,
            ],
            [
                'question' => 'Is my data secure?',
                'answer' => 'Absolutely. We use bank-grade 256-bit encryption and follow industry best practices to ensure your society data is safe and backed up daily.',
                'sort_order' => 2,
            ],
            [
                'question' => 'Can I upgrade my plan later?',
                'answer' => 'Yes, you can upgrade your subscription plan at any time directly from the super admin dashboard as your society grows.',
                'sort_order' => 3,
            ],
            [
                'question' => 'Do you provide support?',
                'answer' => 'We provide dedicated email and chat support. Our Premium plans also include priority phone support and a dedicated account manager.',
                'sort_order' => 4,
            ],
        ];

        foreach ($faqs as $faq) {
            \App\Models\CmsFaq::firstOrCreate(
                ['question' => $faq['question']],
                $faq
            );
        }

        // 4. CMS Testimonials
        $testimonials = [
            [
                'author' => 'Rajesh Kumar',
                'role' => 'Secretary, Palm Heights',
                'quote' => 'Societify transformed how we manage our society. Billing used to take days, now it takes minutes. Highly recommended!',
                'rating' => 5,
                'sort_order' => 1,
            ],
            [
                'author' => 'Priya Sharma',
                'role' => 'Treasurer, Green Valley',
                'quote' => 'The financial reporting is excellent. I can generate audits in a single click. The SaaS model means we can access it from anywhere.',
                'rating' => 5,
                'sort_order' => 2,
            ],
            [
                'author' => 'Amit Patel',
                'role' => 'Resident, Blue Ridge',
                'quote' => 'Love the visitor management feature. I feel much safer knowing exactly who is entering the society premises.',
                'rating' => 5,
                'sort_order' => 3,
            ],
        ];

        foreach ($testimonials as $item) {
            \App\Models\CmsTestimonial::firstOrCreate(
                ['author' => $item['author']],
                $item
            );
        }
    }
}
