<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('rent_records', function (Blueprint $table) {
            $table->string('payment_status', 20)->default('pending')->after('is_paid')
                ->comment('pending, pending_approval, paid');
        });
        
        // Update existing records: if is_paid = true, set payment_status = 'paid'
        DB::statement("UPDATE rent_records SET payment_status = 'paid' WHERE is_paid = 1");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rent_records', function (Blueprint $table) {
            $table->dropColumn('payment_status');
        });
    }
};
