<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('rent_records', function (Blueprint $table) {
            $table->string('receipt_image')->nullable()->after('payment_method')->comment('Path to uploaded receipt image');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rent_records', function (Blueprint $table) {
            $table->dropColumn('receipt_image');
        });
    }
};
