<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rent_records', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('owner_id')->constrained('users')->onDelete('cascade')->comment('For easier querying');
            $table->decimal('amount', 10, 2);
            $table->date('month')->comment('First day of the month (YYYY-MM-01)');
            $table->boolean('is_paid')->default(false);
            $table->dateTime('paid_date')->nullable();
            $table->string('payment_method', 50)->nullable()->comment('cash, online, cheque, etc.');
            $table->text('notes')->nullable();
            $table->timestamps();
            $table->softDeletes();
            
            // Prevent duplicate records for same tenant and month
            $table->unique(['tenant_id', 'month']);
            
            // Indexes for better query performance
            $table->index(['tenant_id', 'is_paid']);
            $table->index(['owner_id', 'month']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rent_records');
    }
};
