<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->decimal('monthly_rent', 10, 2)->nullable()->after('tenant_agreement_end_date');
            $table->integer('rent_increase_duration_months')->nullable()->after('monthly_rent')->comment('Rent increase after this many months (e.g., 12)');
            $table->decimal('rent_increase_percentage', 5, 2)->nullable()->after('rent_increase_duration_months')->comment('Percentage increase (e.g., 10.00)');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'monthly_rent',
                'rent_increase_duration_months',
                'rent_increase_percentage',
            ]);
        });
    }
};
