<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('bank_accounts', function (Blueprint $table) {
            $table->boolean('is_primary')->default(false)->after('balance');
            $table->string('description')->nullable()->after('is_primary');
        });

        Schema::table('payments', function (Blueprint $table) {
            $table->foreignId('collected_by')->nullable()->constrained('users')->nullOnDelete()->after('bank_account_id');
            $table->string('collector_role')->nullable()->after('collected_by');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bank_accounts', function (Blueprint $table) {
            $table->dropColumn(['is_primary', 'description']);
        });

        Schema::table('payments', function (Blueprint $table) {
            $table->dropForeign(['collected_by']);
            $table->dropColumn(['collected_by', 'collector_role']);
        });
    }
};
