<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->unsignedBigInteger('parent_id')->nullable()->after('id');
            $table->string('type')->default('owner')->after('role_id')->comment('owner, tenant, family_member');
            $table->foreign('parent_id')->references('id')->on('users')->onDelete('cascade');
        });

        Schema::table('society_settings', function (Blueprint $table) {
            $table->string('late_fee_calculation_type')->default('none')->after('currency')->comment('none, percentage_daily, fixed_daily');
            $table->decimal('late_fee_value', 8, 2)->default(0)->after('late_fee_calculation_type');
        });

        Schema::table('bills', function (Blueprint $table) {
            $table->decimal('late_fee', 10, 2)->default(0)->after('amount');
            $table->date('last_interest_applied_at')->nullable()->after('status'); // Safer placement
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['parent_id']);
            $table->dropColumn(['parent_id', 'type']);
        });

        Schema::table('society_settings', function (Blueprint $table) {
            $table->dropColumn(['late_fee_calculation_type', 'late_fee_value']);
        });

        Schema::table('bills', function (Blueprint $table) {
            $table->dropColumn(['late_fee', 'last_interest_applied_at']);
        });
    }
};
