<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('community_posts', function (Blueprint $table) {
            $table->string('media_type')->default('text')->after('content'); // 'text', 'image', 'video'
            $table->json('media_urls')->nullable()->after('media_type'); // Store multiple paths
            $table->boolean('is_highlighted')->default(false)->after('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('community_posts', function (Blueprint $table) {
            $table->dropColumn(['media_type', 'media_urls', 'is_highlighted']);
        });
    }
};
