<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Ad Slots Configuration (Per Society)
        Schema::create('ad_slots', function (Blueprint $table) {
            $table->id();
            $table->foreignId('society_id')->constrained('societies')->cascadeOnDelete();
            $table->string('position'); // 'app_open_popup', 'community_top', 'community_bottom'
            $table->string('name')->nullable(); // Friendly name
            $table->decimal('price_per_day', 10, 2)->default(0);
            $table->integer('max_concurrent_ads')->default(5);
            $table->boolean('status')->default(true); // Active/Inactive
            $table->timestamps();

            // Ensure one configuration per position per society (unless we want multiple slots in same position)
            $table->unique(['society_id', 'position']);
        });

        // Advertisements
        Schema::create('advertisements', function (Blueprint $table) {
            $table->id();
            $table->foreignId('society_id')->constrained('societies')->cascadeOnDelete();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->foreignId('slot_id')->nullable()->constrained('ad_slots')->nullOnDelete();
            
            $table->string('title');
            $table->text('description')->nullable();
            
            $table->string('media_url')->nullable(); // Image or Video URL
            $table->string('media_type')->default('image'); // 'image', 'video'
            $table->string('target_link')->nullable();
            
            $table->dateTime('start_date');
            $table->dateTime('end_date');
            
            $table->string('payment_reference')->nullable();
            $table->string('payment_status')->default('pending'); // pending, paid, failed
            
            // Status: pending_approval, approved, rejected, active, expired, payment_pending
            $table->string('status')->default('pending_approval');
            $table->text('admin_notes')->nullable(); // Rejection reason
            
            $table->timestamps();
            $table->softDeletes();
            
            // Stats (optional but useful)
            $table->unsignedBigInteger('views')->default(0);
            $table->unsignedBigInteger('clicks')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('advertisements');
        Schema::dropIfExists('ad_slots');
    }
};
