<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Comments Table
        Schema::create('comments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ticket_id')->constrained('maintenance_tickets')->cascadeOnDelete();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->text('message');
            $table->json('images')->nullable();
            $table->boolean('is_internal')->default(false);
            $table->timestamps();
        });

        // Ticket Timelines Table
        Schema::create('ticket_timelines', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ticket_id')->constrained('maintenance_tickets')->cascadeOnDelete();
            $table->string('action'); // created, assigned, comment_added, status_changed, resolved
            $table->text('description')->nullable(); // detailed description
            $table->foreignId('user_id')->nullable()->constrained('users')->onDelete('set null'); // Who performed action
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ticket_timelines');
        Schema::dropIfExists('comments');
    }
};
