<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('expenses', function (Blueprint $table) {
            $table->decimal('gst_percentage', 5, 2)->nullable()->after('amount');
            $table->decimal('gst_amount', 10, 2)->nullable()->after('gst_percentage');
            $table->decimal('total_amount', 10, 2)->nullable()->after('gst_amount');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('expenses', function (Blueprint $table) {
            $table->dropColumn(['gst_percentage', 'gst_amount', 'total_amount']);
        });
    }
};
